using System;
using Server.Items;
using Server.Network;

namespace Server.Items 
{ 
   [FlipableAttribute( 7701, 7702 )] 
   public class RawFish : Item
   { 
	  
	  [Constructable]
		public RawFish() : base( 7701 )
		{
			Weight = 1.0;
         Name = "Raw Fish";
			Movable = true;
		}

      public RawFish( Serial serial ) : base( serial ) 
      { 
      } 
      public override void Serialize( GenericWriter writer )
      { 
         base.Serialize( writer ); 

         writer.Write( (int) 0 ); // version 
      } 

      public override void Deserialize( GenericReader reader ) 
      { 
         base.Deserialize( reader ); 

         int version = reader.ReadInt(); 
      } 
   } 
   
   [FlipableAttribute( 7703, 7704 )] 
   public class RawFish2 : Item
   { 
	  
	  [Constructable]
		public RawFish2() : base( 7703 )
		{
			Weight = 1.0;
         Name = "Raw Fish";
			Movable = true;
		}

      public RawFish2( Serial serial ) : base( serial ) 
      { 
      } 
      public override void Serialize( GenericWriter writer )
      { 
         base.Serialize( writer ); 

         writer.Write( (int) 0 ); // version 
      } 

      public override void Deserialize( GenericReader reader ) 
      { 
         base.Deserialize( reader ); 

         int version = reader.ReadInt(); 
      } 
   } 
   
   [FlipableAttribute( 7705, 7706 )] 
   public class FishHead : Item
   { 
	  
	  [Constructable]
		public FishHead() : base( 7705 )
		{
			Weight = 1.0;
         Name = "Fish Head";
			Movable = true;
		}

      public FishHead( Serial serial ) : base( serial ) 
      { 
      } 
      public override void Serialize( GenericWriter writer )
      { 
         base.Serialize( writer ); 

         writer.Write( (int) 0 ); // version 
      } 

      public override void Deserialize( GenericReader reader ) 
      { 
         base.Deserialize( reader ); 

         int version = reader.ReadInt(); 
      } 
   } 
   
   public class FishHeads : Item
   { 
	  
	  [Constructable]
		public FishHeads() : base( 7707 )
		{
			Weight = 2.0;
         Name = "Fish Heads";
			Movable = true;
		}

      public FishHeads( Serial serial ) : base( serial ) 
      { 
      } 
      public override void Serialize( GenericWriter writer )
      { 
         base.Serialize( writer ); 

         writer.Write( (int) 0 ); // version 
      } 

      public override void Deserialize( GenericReader reader ) 
      { 
         base.Deserialize( reader ); 

         int version = reader.ReadInt(); 
      } 
   } 
}