using System;

namespace Server.Items
{

	[FlipableAttribute(0x160D, 0x160E)]
	public class RedCurtain : Item, IDyable
	{
		[Constructable]
		public RedCurtain() : base(0x160D)
		{
			Weight = 6;
			Movable = true;
		}

		public RedCurtain(Serial serial) : base(serial)
		{
		}

		public bool Dye( Mobile from, DyeTub sender )
		{
			if ( Deleted )
				return false;

			Hue = sender.DyedHue;

			return true;
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();
		}
	}
}