using System;

namespace Server.Items
{

	[FlipableAttribute(0x159E, 0x159F)]
	public class SmallWhiteCurtain : Item, IDyable
	{
		[Constructable]
		public SmallWhiteCurtain() : base(0x159E)
		{
			Name = "Small White Curtain";
			Weight = 2;
			Movable = true;
		}

		public SmallWhiteCurtain(Serial serial) : base(serial)
		{
		}

		public bool Dye( Mobile from, DyeTub sender )
		{
			if ( Deleted )
				return false;

			Hue = sender.DyedHue;

			return true;
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();
		}
	}
}