using System;
using Server.Network; 

namespace Server.Items 
{ 
   [Flipable( 0xA6C, 0xA6D, 0xA6E, 0xA6F)]
   public class Blanket : BaseDecorationArtifact 
   { 
      public override int ArtifactRarity{ get{ return 1; } }
      [Constructable] 
      public Blanket() : base( 0xA6C ) 
      { 
         Movable = false;
         ItemFlags.SetStealable(this,true);
         Hue = Utility.RandomNondyedHue();
      } 

      public Blanket( Serial serial ) : base( serial ) 
      { 
      } 

      public override void Serialize( GenericWriter writer ) 
      { 
         base.Serialize( writer ); 

         writer.Write( (int) 0 ); // version 
      } 

      public override void Deserialize( GenericReader reader ) 
      { 
         base.Deserialize( reader ); 

         int version = reader.ReadInt(); 
      } 
   } 
    
} 
