using System;
using Server.Network; 

namespace Server.Items 
{ 

   [FlipableAttribute( 0xFAC, 0xFAC )] 
   public class FirePit : BaseDecorationArtifact 
   { 
      public override int ArtifactRarity{ get{ return 3; } }
      [Constructable] 
      public FirePit() : base( 0xFAC ) 
      { 
         Movable = false; 
         ItemFlags.SetStealable(this,true);
      } 

      public FirePit( Serial serial ) : base( serial ) 
      { 
      } 

      public override void Serialize( GenericWriter writer ) 
      { 
         base.Serialize( writer ); 

         writer.Write( (int) 0 ); // version 
      } 

      public override void Deserialize( GenericReader reader ) 
      { 
         base.Deserialize( reader ); 

         int version = reader.ReadInt(); 
      } 
   } 
    
}
