using System;
using Server.Network; 

namespace Server.Items 
{ 

   [FlipableAttribute( 0x1024, 0x1025 )] 
   public class StrangeShafts : BaseDecorationArtifact
   { 
      public override int ArtifactRarity{ get{ return 1; } }
      [Constructable] 
      public StrangeShafts() : base( 0x1024 )
      { 
         Movable = false;
         ItemFlags.SetStealable(this,true);
      } 

      public StrangeShafts( Serial serial ) : base( serial )
      { 
      } 

      public override void Serialize( GenericWriter writer ) 
      { 
         base.Serialize( writer ); 

         writer.Write( (int) 0 ); // version 
      } 

      public override void Deserialize( GenericReader reader ) 
      { 
         base.Deserialize( reader ); 

         int version = reader.ReadInt(); 
      } 
   } 
   
   [FlipableAttribute( 0x1026, 0x1027 )]
   public class Chisel : BaseDecorationArtifact
   { 
      public override int ArtifactRarity{ get{ return 1; } }
      [Constructable] 
      public Chisel() : base( 0x1026 )
      { 
         Movable = false;
      }

      public Chisel( Serial serial ) : base( serial )
      { 
      } 

      public override void Serialize( GenericWriter writer ) 
      { 
         base.Serialize( writer ); 

         writer.Write( (int) 0 ); // version 
      } 

      public override void Deserialize( GenericReader reader ) 
      { 
         base.Deserialize( reader ); 

         int version = reader.ReadInt(); 
      } 
   }
   
   [FlipableAttribute( 0x1EBA, 0x1EBB )]
   public class SquareToolkit : BaseDecorationArtifact
   { 
      public override int ArtifactRarity{ get{ return 2; } }
      [Constructable] 
      public SquareToolkit() : base( 0x1EBA )
      { 
         Movable = false;
         ItemFlags.SetStealable(this,true);
      } 

      public SquareToolkit( Serial serial ) : base( serial )
      { 
      } 

      public override void Serialize( GenericWriter writer ) 
      { 
         base.Serialize( writer ); 

         writer.Write( (int) 0 ); // version 
      } 

      public override void Deserialize( GenericReader reader ) 
      { 
         base.Deserialize( reader ); 

         int version = reader.ReadInt(); 
      } 
   } 
    
    
} 
