using System;
using Server.Network; 

namespace Server.Items 
{ 
	public abstract class BaseStealTrainer : Item
	{
		public abstract int ArtifactRarity{ get; }

		public override bool ForceShowProperties{ get{ return true; } }

		public BaseStealTrainer( int itemID ) : base( itemID )
		{
		}

		public override void GetProperties( ObjectPropertyList list )
		{
			base.GetProperties( list );

			list.Add( 1061078, this.ArtifactRarity.ToString() ); // artifact rarity ~1_val~
		}

		public BaseStealTrainer( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.WriteEncodedInt( 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadEncodedInt();
		}
	}
   
   public class StealTrainer1 : BaseStealTrainer
   { 
		public override int ArtifactRarity{ get{ return 1; } }
		
      [Constructable] 
      public StealTrainer1() : base( 6254 ) 
      { 
         Name = "Ukradni to!";
         Weight = 3.5;
         Movable = false; 
         ItemFlags.SetStealable(this,true);
      } 

      public StealTrainer1( Serial serial ) : base( serial ) 
      { 
      } 

      public override void Serialize( GenericWriter writer ) 
      { 
         base.Serialize( writer ); 

         writer.Write( (int) 0 ); // version 
      } 

      public override void Deserialize( GenericReader reader ) 
      { 
         base.Deserialize( reader ); 

         int version = reader.ReadInt(); 
      } 
   }
   
   public class StealTrainer2 : BaseStealTrainer
   { 
      public override int ArtifactRarity{ get{ return 2; } }
      
      [Constructable] 
      public StealTrainer2() : base( 6255 ) 
      { 
         Name = "Ukradni to!";
         Weight = 5.5;
         Movable = false; 
         ItemFlags.SetStealable(this,true);
      } 

      public StealTrainer2( Serial serial ) : base( serial ) 
      { 
      } 

      public override void Serialize( GenericWriter writer ) 
      { 
         base.Serialize( writer ); 

         writer.Write( (int) 0 ); // version 
      } 

      public override void Deserialize( GenericReader reader ) 
      { 
         base.Deserialize( reader ); 

         int version = reader.ReadInt(); 
      } 
   } 
   
   public class StealTrainer3 : BaseStealTrainer
   { 
      public override int ArtifactRarity{ get{ return 3; } }
      
      [Constructable] 
      public StealTrainer3() : base( 6256 ) 
      { 
         Name = "Ukradni to!";
         Weight = 8.5;
         Movable = false; 
         ItemFlags.SetStealable(this,true);
      } 

      public StealTrainer3( Serial serial ) : base( serial ) 
      { 
      } 

      public override void Serialize( GenericWriter writer ) 
      { 
         base.Serialize( writer ); 

         writer.Write( (int) 0 ); // version 
      } 

      public override void Deserialize( GenericReader reader ) 
      { 
         base.Deserialize( reader ); 

         int version = reader.ReadInt(); 
      } 
   } 
} 
