using System;
using Server.Items;
using Server.Network;

namespace Server.Items 
{ 
   
   [FlipableAttribute( 0xC10, 0xC11 )] 
   public class BrokenChair : BaseDecorationArtifact
   { 
      public override int ArtifactRarity{ get{ return 3; } }
	  [Constructable]
		public BrokenChair() : base( 0xC10 )
		{
			Weight = 7.0;
         Name = "a broken chair";
			Movable = false;
			ItemFlags.SetStealable(this,true);
		}

      public BrokenChair( Serial serial ) : base( serial ) 
      { 
      } 
      public override void Serialize( GenericWriter writer )
      { 
         base.Serialize( writer ); 

         writer.Write( (int) 0 ); // version 
      } 

      public override void Deserialize( GenericReader reader ) 
      { 
         base.Deserialize( reader ); 

         int version = reader.ReadInt(); 
      } 
   } 

	[FlipableAttribute( 0xC13, 0xC12 )] 
	public class RuinedArmoireS : BaseDecorationArtifact
	{
      public override int ArtifactRarity{ get{ return 3; } }
      [Constructable]
		public RuinedArmoireS() : base( 0xC13 )
		{
			Movable = false;
			ItemFlags.SetStealable(this,true);
		}

		public RuinedArmoireS( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	
	[FlipableAttribute( 0xC14, 0xC15 )] 
	public class RuinedBookscaseS : BaseDecorationArtifact
	{
      public override int ArtifactRarity{ get{ return 3; } }
      [Constructable]
		public RuinedBookscaseS() : base( 0xC14 )
		{
			Movable = false;
			ItemFlags.SetStealable(this,true);
		}

		public RuinedBookscaseS( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	
	[FlipableAttribute( 0xC17, 0xC18 )] 
	public class CoveredChairS : BaseDecorationArtifact
	{
      public override int ArtifactRarity{ get{ return 3; } }
      [Constructable]
		public CoveredChairS() : base( 0xC17 )
		{
			Movable = false;
			ItemFlags.SetStealable(this,true);
		}

		public CoveredChairS( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}

	}

	[FlipableAttribute( 0xC19, 0xC1A )] 
	public class RuinedFallenChairS : BaseDecorationArtifact
	{
      public override int ArtifactRarity{ get{ return 3; } }
      [Constructable]
		public RuinedFallenChairS() : base( 0xC19 )
		{
			Movable = false;
			ItemFlags.SetStealable(this,true);
		}

		public RuinedFallenChairS( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}

	}

	[FlipableAttribute( 0xC1B, 0xC1C, 0xC1E, 0xC1D )]
	public class RuinedChairS : BaseDecorationArtifact
	{
      public override int ArtifactRarity{ get{ return 3; } }
      [Constructable]
		public RuinedChairS() : base( 0xC1B )
		{
			Movable = false;
			ItemFlags.SetStealable(this,true);
		}

		public RuinedChairS( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	
	[FlipableAttribute( 0xC24, 0xC25 )]
	public class RuinedDrawersS : BaseDecorationArtifact
	{
      public override int ArtifactRarity{ get{ return 3; } }
      [Constructable]
		public RuinedDrawersS() : base( 0xC24 )
		{
			Movable = false;
			ItemFlags.SetStealable(this,true);
		}

		public RuinedDrawersS( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
	
	[FlipableAttribute( 0xC2D, 0xC2F, 0xC2E, 0xC30 )]
	public class WoodDebrisS : BaseDecorationArtifact
	{
      public override int ArtifactRarity{ get{ return 2; } }
      [Constructable]
		public WoodDebrisS() : base( 0xC2D )
		{
			Movable = false;
			ItemFlags.SetStealable(this,true);
		}

		public WoodDebrisS( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
} 
