using System;
using Server.Items;
using Server.Network;

namespace Server.Items 
{ 
   [FlipableAttribute( 7793, 7802 )] 
   public class UnfinishedDrawers : BaseDecorationArtifact
   { 
      public override int ArtifactRarity{ get{ return 3; } }
     [Constructable]
		public UnfinishedDrawers() : base( 7793 )
		{
			Weight = 7.0;
         Name = "a unfinished drawers";
			Movable = false;
			ItemFlags.SetStealable(this,true);
		}

      public UnfinishedDrawers( Serial serial ) : base( serial ) 
      { 
      } 
      public override void Serialize( GenericWriter writer )
      { 
         base.Serialize( writer ); 

         writer.Write( (int) 0 ); // version 
      } 

      public override void Deserialize( GenericReader reader ) 
      { 
         base.Deserialize( reader ); 

         int version = reader.ReadInt(); 
      } 
   } 

   [FlipableAttribute( 7791, 7800 )] 
   public class UnfinishedChair : BaseDecorationArtifact
   { 
      public override int ArtifactRarity{ get{ return 3; } }
	  [Constructable]
		public UnfinishedChair() : base( 7791 )
		{
			Weight = 4.0;
         Name = "a unfinished chair";
			Movable = false;
			ItemFlags.SetStealable(this,true);
		}

      public UnfinishedChair( Serial serial ) : base( serial ) 
      { 
      } 
      public override void Serialize( GenericWriter writer )
      { 
         base.Serialize( writer ); 

         writer.Write( (int) 0 ); // version 
      } 

      public override void Deserialize( GenericReader reader ) 
      { 
         base.Deserialize( reader ); 

         int version = reader.ReadInt(); 
      } 
   } 
   
   [FlipableAttribute( 7798, 7806 )] 
   public class UnfinishedShelves : BaseDecorationArtifact
   { 
      public override int ArtifactRarity{ get{ return 3; } }
	  [Constructable]
		public UnfinishedShelves() : base( 7798 )
		{
			Weight = 7.0;
         Name = "a unfinished shelves";
			Movable = false;
			ItemFlags.SetStealable(this,true);
		}

      public UnfinishedShelves( Serial serial ) : base( serial ) 
      { 
      } 
      public override void Serialize( GenericWriter writer )
      { 
         base.Serialize( writer ); 

         writer.Write( (int) 0 ); // version 
      } 

      public override void Deserialize( GenericReader reader ) 
      { 
         base.Deserialize( reader ); 

         int version = reader.ReadInt(); 
      } 
   } 
   
   [FlipableAttribute( 7790, 7799 )] 
   public class UnfinishedBoard : BaseDecorationArtifact
   { 
      public override int ArtifactRarity{ get{ return 1; } }
	  [Constructable]
		public UnfinishedBoard() : base( 7790 )
		{
			Weight = 2.0;
         Name = "a unfinished board";
			Movable = false;
			ItemFlags.SetStealable(this,true);
		}

      public UnfinishedBoard( Serial serial ) : base( serial ) 
      { 
      } 
      public override void Serialize( GenericWriter writer )
      { 
         base.Serialize( writer ); 

         writer.Write( (int) 0 ); // version 
      } 

      public override void Deserialize( GenericReader reader ) 
      { 
         base.Deserialize( reader ); 

         int version = reader.ReadInt(); 
      } 
   } 
   
   [FlipableAttribute( 7792, 7801 )] 
   public class UnfinishedDrawer : BaseDecorationArtifact
   { 
      public override int ArtifactRarity{ get{ return 2; } }
	  [Constructable]
		public UnfinishedDrawer() : base( 7792 )
		{
			Weight = 2.0;
         Name = "a unfinished drawer";
			Movable = false;
			ItemFlags.SetStealable(this,true);
		}

      public UnfinishedDrawer( Serial serial ) : base( serial ) 
      { 
      } 
      public override void Serialize( GenericWriter writer )
      { 
         base.Serialize( writer ); 

         writer.Write( (int) 0 ); // version 
      } 

      public override void Deserialize( GenericReader reader ) 
      { 
         base.Deserialize( reader ); 

         int version = reader.ReadInt(); 
      } 
   } 
   
   [FlipableAttribute( 7794, 7803 )] 
   public class UnfinishedTable : BaseDecorationArtifact
   { 
      public override int ArtifactRarity{ get{ return 3; } }
	  [Constructable]
		public UnfinishedTable() : base( 7794 )
		{
			Weight = 5.0;
         Name = "a unfinished table";
			Movable = false;
			ItemFlags.SetStealable(this,true);
		}

      public UnfinishedTable( Serial serial ) : base( serial ) 
      { 
      } 
      public override void Serialize( GenericWriter writer )
      { 
         base.Serialize( writer ); 

         writer.Write( (int) 0 ); // version 
      } 

      public override void Deserialize( GenericReader reader ) 
      { 
         base.Deserialize( reader ); 

         int version = reader.ReadInt(); 
      } 
   } 
   
   [FlipableAttribute( 7795, 7804 )] 
   public class UnfinishedTableLegs : BaseDecorationArtifact
   { 
      public override int ArtifactRarity{ get{ return 1; } }
	  [Constructable]
		public UnfinishedTableLegs() : base( 7795 )
		{
			Weight = 3.0;
         Name = "a unfinished table legs";
			Movable = false;
			ItemFlags.SetStealable(this,true);
		}

      public UnfinishedTableLegs( Serial serial ) : base( serial ) 
      { 
      } 
      public override void Serialize( GenericWriter writer )
      { 
         base.Serialize( writer ); 

         writer.Write( (int) 0 ); // version 
      } 

      public override void Deserialize( GenericReader reader ) 
      { 
         base.Deserialize( reader ); 

         int version = reader.ReadInt(); 
      } 
   } 
   
   [FlipableAttribute( 7796, 7805 )] 
   public class UnfinishedTableLeg : BaseDecorationArtifact
   { 
      public override int ArtifactRarity{ get{ return 1; } }
	  [Constructable]
		public UnfinishedTableLeg() : base( 7796 )
		{
			Weight = 2.0;
         Name = "a unfinished table leg";
			Movable = false;
			ItemFlags.SetStealable(this,true);
		}

      public UnfinishedTableLeg( Serial serial ) : base( serial ) 
      { 
      } 
      public override void Serialize( GenericWriter writer )
      { 
         base.Serialize( writer ); 

         writer.Write( (int) 0 ); // version 
      } 

      public override void Deserialize( GenericReader reader ) 
      { 
         base.Deserialize( reader ); 

         int version = reader.ReadInt(); 
      } 
   } 
   
   [FlipableAttribute( 7808, 7809 )] 
   public class UnfinishedWoodenBox : BaseDecorationArtifact
   { 
      public override int ArtifactRarity{ get{ return 3; } }
	  [Constructable]
		public UnfinishedWoodenBox() : base( 7808 )
		{
			Weight = 3.0;
         Name = "a unfinished wooden box";
			Movable = false;
			ItemFlags.SetStealable(this,true);
		}

      public UnfinishedWoodenBox( Serial serial ) : base( serial ) 
      { 
      } 
      public override void Serialize( GenericWriter writer )
      { 
         base.Serialize( writer ); 

         writer.Write( (int) 0 ); // version 
      } 

      public override void Deserialize( GenericReader reader ) 
      { 
         base.Deserialize( reader ); 

         int version = reader.ReadInt(); 
      } 
   } 
   
   public class UnfinishedStool : BaseDecorationArtifact
   { 
      public override int ArtifactRarity{ get{ return 3; } }
     [Constructable]
		public UnfinishedStool() : base( 7807 )
		{
			Weight = 4.0;
         Name = "a unfinished stool";
			Movable = false;
			ItemFlags.SetStealable(this,true);
		}

      public UnfinishedStool( Serial serial ) : base( serial ) 
      { 
      } 
      public override void Serialize( GenericWriter writer )
      { 
         base.Serialize( writer ); 

         writer.Write( (int) 0 ); // version 
      } 

      public override void Deserialize( GenericReader reader ) 
      { 
         base.Deserialize( reader ); 

         int version = reader.ReadInt(); 
      } 
   } 
   
   public class UnfinishedLatheWork : BaseDecorationArtifact
   { 
      public override int ArtifactRarity{ get{ return 2; } }
     [Constructable]
		public UnfinishedLatheWork() : base( 7810 )
		{
			Weight = 3.0;
         Name = "a unfinished lathe work";
			Movable = false;
			ItemFlags.SetStealable(this,true);
		}

      public UnfinishedLatheWork( Serial serial ) : base( serial ) 
      { 
      } 
      public override void Serialize( GenericWriter writer )
      { 
         base.Serialize( writer ); 

         writer.Write( (int) 0 ); // version 
      } 

      public override void Deserialize( GenericReader reader ) 
      { 
         base.Deserialize( reader ); 

         int version = reader.ReadInt(); 
      } 
   } 
} 
