using System;
using Server.Network; 

namespace Server.Items 
{ 

   [FlipableAttribute( 0xFFA, 0xFFA )] 
   public class WaterBucket : BaseDecorationArtifact
   { 
      public override int ArtifactRarity{ get{ return 2; } }
      [Constructable] 
      public WaterBucket() : base( 0xFFA ) 
      { 
         Movable = false; 
         ItemFlags.SetStealable(this,true);
      } 

      public WaterBucket( Serial serial ) : base( serial ) 
      { 
      } 

      public override void Serialize( GenericWriter writer ) 
      { 
         base.Serialize( writer ); 

         writer.Write( (int) 0 ); // version 
      } 

      public override void Deserialize( GenericReader reader ) 
      { 
         base.Deserialize( reader ); 

         int version = reader.ReadInt(); 
      } 
   } 
    
} 
