using System;

namespace Server.Items
{
    public class ArcaneDust : Item
    {
        [Constructable]
        public ArcaneDust() : this(5)
        {
        }

        [Constructable]
        public ArcaneDust(int amount) : base(3983)
        {
            Name = "arcane dust";
            Weight = 0.1;
            Stackable = true;
            Amount = amount;
            Hue = 2167;
        }

        public ArcaneDust(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);
            writer.Write((int)0);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);
            int version = reader.ReadInt();
        }
    }
}