using System;
using Server.Network;
using Server.Prompts;
using Server.Items;
using Server.Targeting;

namespace Server.Items
{
	public class BattleLustTarget : Target
	{
		private BattleLustScroll m_Scroll;

		public BattleLustTarget( BattleLustScroll scroll ) : base( 1, false, TargetFlags.None )
		{
			m_Scroll = scroll;
		}

		protected override void OnTarget( Mobile from, object target )
		{
			/*if ( target is ILevelable )
            from.SendMessage( "Svitek nelze pouzit na levelovaci predmety!" );
         else */
         if ( target is BaseMeleeWeapon )
			{
				BaseWeapon item = (BaseWeapon) target;
				
            if( item.RootParent != from )
					from.SendMessage( "Musis mit predmet u sebe" );
				else if ( item.Type == WeaponType.Ranged || item is BaseRanged || item is NoAmmoRanged || item is MagicRanged )
					from.SendMessage( "Na strelne zbrane nelze svitek pouzit" );
            else if( item.BlessedFor != null && item.BlessedFor != from )
					from.SendMessage( "Toto neni tvuj predmet" );
            else if( item.WeaponAttributes.BattleLust > 0 )
					from.SendMessage( "Tato zbran jiz vlastnost Battle Lust obsahuje!" );
				else
				{
					item.WeaponAttributes.BattleLust = 1;
					item.BlessedFor = from;
					from.SendMessage( "Vlastnost Battle Lust byla uspesne pridana." );
					m_Scroll.Delete();
				}
			}
			else
				from.SendMessage( "Svitek lze pouzit pouze na melee zbran." );
		}
	}

	public class BattleLustScroll : Item
	{
		[Constructable]
		public BattleLustScroll() : base( 5357 )
		{
			Weight = 1.0;
			Hue = 2522;
			Name = "a battle lust scroll";
			LootType = LootType.Blessed;
		}

		public BattleLustScroll( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}

		public override bool DisplayLootType{ get{ return false; } }

		public override void OnDoubleClick( Mobile from )
		{
			if ( !IsChildOf( from.Backpack ) ) // Make sure its in their pack
			{
				from.SendLocalizedMessage( 1060640 );
			}
			else
			{
				from.SendMessage( "Do jake melee zbrane chces pridat vlastnost Battle Lust?" );
				from.SendMessage( 33, "POZOR! Zbran, kterou vylepsis budes moci pouzivat jen ty!" );
				from.Target = new BattleLustTarget( this );
			}
		}
	}
}


