//----------------------------------------------------------------------------------//
// Created by Vano. Email: vano2006uo@mail.ru      //
//---------------------------------------------------------------------------------//
using System;
using Server;
using Server.Mobiles;
using Server.Network;
using Server.Multis;
using Server.Gumps;
//using Server.Misc;

namespace Server.Items
{
	public class ChangeRaceDeed : Item
	{
		[Constructable]
		public ChangeRaceDeed() : base( 0x14F0 )
		{
			Name = "Change Race Deed";
			Weight = 1.0;
			LootType = LootType.Blessed;
			Hue = 73;
		}

		public ChangeRaceDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); //version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}

		public override void OnDoubleClick( Mobile from )
		{
			if ( !IsChildOf( from.Backpack ) )
			{
				from.SendLocalizedMessage( 1042001 ); // That must be in your pack for you to use it.
			}
			else
			{
				if ( from.IsBodyMod )
					from.SendMessage( "You can't use this deed." );
            else if ( from.Race == Race.Elf && ( from.Body == 0x25E || from.Body == 0x25D ) )
				{
					from.SendGump( new ConfirmToHumanGump( this ) );
				}
				else if ( from.Race == Race.Human && ( from.Body == 0x190 || from.Body == 0x191 ) )
				{
					from.SendGump( new ConfirmToElfGump( this ) );
				}
				else
				{
					from.SendMessage( "You can't use this deed." );
				}
			}
		}
		
		private class ConfirmToElfGump : BaseConfirmGump
		{
			public override int TitleNumber{ get{ return 1075083; } } // <center>Warning!</center>
			public override int LabelNumber{ get{ return 1073642; } } // Are you sure you want to follow the elven ways?
			
			private Item m_Item;
			
			public ConfirmToElfGump( Item item ) : base()
			{
				m_Item = item;
			}
			
			public override void Confirm( Mobile from )
			{		
			   if ( m_Item == null || m_Item.Deleted )
				  return;
				  
				from.Race = Race.Elf;
// 				from.SetHairMods( -1, -1 ); // clear any hairmods (disguise kit, incognito)
            if ( from.Female)
            {
               from.Body = 0x25E;
               from.HairItemID = Utility.RandomList( 0x2FBF, 0x2FC0, 0x2FC1, 0x2FC2, 0x2FCC, 0x2FCD, 0x2FCE, 0x2FCF, 0x2FD0, 0x2FD1, 0x2FD1 );
            }
            else
            {
               from.Body = 0x25D;
               from.HairItemID = Utility.RandomList( 0x2FBF, 0x2FC0, 0x2FC1, 0x2FC2, 0x2FCC, 0x2FCD, 0x2FCE, 0x2FCF, 0x2FD0, 0x2FD1, 0x2FD1 );
               from.FacialHairItemID = 0;
            }
				from.SendMessage( 0x32, "Nyni jsi elf." );
				m_Item.Delete();
			}
		}
		
		private class ConfirmToHumanGump : BaseConfirmGump
		{
			public override int TitleNumber{ get{ return 1075083; } } // <center>Warning!</center>
			public override int LabelNumber{ get{ return 1073643; } } // Are you sure you wish to embrace your humanity?
			
			private Item m_Item;
			
			public ConfirmToHumanGump( Item item ) : base()
			{
				m_Item = item;
			}
			
			public override void Confirm( Mobile from )
			{		
			   if ( m_Item == null || m_Item.Deleted )
				  return;
				  
            from.Race = Race.Human;
// 				from.SetHairMods( -1, -1 ); // clear any hairmods (disguise kit, incognito)
            if ( from.Female)
            {
               from.Body = 0x191;
               from.HairItemID = Utility.RandomList( 0x203B, 0x203C, 0x203D, 0x2045, 0x204A, 0x2046 , 0x2049 );
            }
            else
            {
               from.Body = 0x190;
               from.HairItemID = Utility.RandomList( 0x203B, 0x203C, 0x203D, 0x2044, 0x2045, 0x2047, 0x2048 );
            }
				from.SendMessage( 0x32, "Nyni jsi clovek." );
				m_Item.Delete();
			}
		}
	}
}