using System;
using Server;
using Server.Targeting;
using Server.Network;
using Server.Prompts;

namespace Server.Items
{
	public class ClothingSkillScroll : Item
	{
		private SkillName m_Skill;
		private double m_Value;

		private static SkillName[] m_Skills = new SkillName[]
		{
			SkillName.Alchemy, //0,
			SkillName.Anatomy, //1,
			SkillName.AnimalLore, //2,
			SkillName.ItemID, //3,
			SkillName.ArmsLore, //4,
			SkillName.Parry, //5,
			SkillName.Begging, //6,
			SkillName.Blacksmith, //7,
			SkillName.Fletching, //8,
			SkillName.Peacemaking, //9,
			SkillName.Camping, //10,
			SkillName.Carpentry, //11,
			SkillName.Cartography, //12,
			SkillName.Cooking, //13,
			SkillName.DetectHidden, //14,
			SkillName.Discordance, //15,
			SkillName.EvalInt, //16,
			SkillName.Healing, //17,
			SkillName.Fishing, //18,
			SkillName.Forensics, //19,
			SkillName.Herding, //20,
			SkillName.Hiding, //21,
			SkillName.Provocation, //22,
			SkillName.Inscribe, //23,
			SkillName.Lockpicking, //24,
			SkillName.Magery, //25,
			SkillName.MagicResist, //26,
			SkillName.Tactics, //27,
			SkillName.Snooping, //28,
			SkillName.Musicianship, //29,
			SkillName.Poisoning, //30,
			SkillName.Archery, //31,
			SkillName.SpiritSpeak, //32,
			SkillName.Stealing, //33,
			SkillName.Tailoring, //34,
			SkillName.AnimalTaming, //35,
			SkillName.TasteID, //36,
			SkillName.Tinkering, //37,
			SkillName.Tracking, //38,
			SkillName.Veterinary, //39,
			SkillName.Swords, //40,
			SkillName.Macing, //41,
			SkillName.Fencing, //42,
			SkillName.Wrestling, //43,
			SkillName.Lumberjacking, //44,
			SkillName.Mining, //45,
			SkillName.Meditation, //46,
			SkillName.Stealth, //47,
			SkillName.RemoveTrap, //48,
			SkillName.Necromancy, //49,
			SkillName.Focus, //50,
			SkillName.Chivalry, //51,
			SkillName.Bushido, //52,
			SkillName.Ninjitsu, //53,
			SkillName.Spellweaving //54
		};

		public static SkillName[] Skills{ get{ return m_Skills; } }

		public static ClothingSkillScroll CreateRandom( int min, int max )
		{
			SkillName[] skills = ClothingSkillScroll.Skills;

			return new ClothingSkillScroll( skills[Utility.Random( skills.Length )], Utility.RandomMinMax( min, max ) );
		}

		public static ClothingSkillScroll CreateRandomNoCraft( int min, int max )
		{
			SkillName[] skills = ClothingSkillScroll.Skills;
			SkillName skillName;

			do
			{
				skillName = skills[Utility.Random( skills.Length )];
			} while ( skillName == SkillName.Blacksmith || skillName == SkillName.Tailoring || skillName == SkillName.Lumberjacking
			         || skillName == SkillName.Alchemy || skillName == SkillName.Fletching || skillName == SkillName.Carpentry
			         || skillName == SkillName.Cartography || skillName == SkillName.Cooking || skillName == SkillName.Inscribe
			         || skillName == SkillName.Mining || skillName == SkillName.Tinkering || skillName == SkillName.Fishing);

			return new ClothingSkillScroll( skillName, Utility.RandomMinMax( min, max ) );
		}
		
		public static ClothingSkillScroll CreateRandomCraft( int min, int max )
		{
			SkillName[] skills = ClothingSkillScroll.Skills;
			SkillName skillName;

			switch ( Utility.Random( 12 ) )
			{
					case 0:skillName = SkillName.Blacksmith;break;
					case 1:skillName = SkillName.Tailoring;break;
					case 2:skillName = SkillName.Alchemy;break;
					case 3:skillName = SkillName.Fletching;break;
					case 4:skillName = SkillName.Carpentry;break;
					case 5:skillName = SkillName.Cartography;break;
					case 6:skillName = SkillName.Cooking;break;
					case 7:skillName = SkillName.Inscribe;break;
					case 8:skillName = SkillName.Mining;break;
					case 9:skillName = SkillName.Tinkering;break;
					case 10:skillName = SkillName.Lumberjacking;break;
					case 11:skillName = SkillName.Fishing;break;
					default:skillName = SkillName.Blacksmith;break;
			}
			
			return new ClothingSkillScroll( skillName, Utility.RandomMinMax( min, max ) );
		}

		[Constructable]
		public ClothingSkillScroll( SkillName skill, double value ) : base( 0x14F0 )
		{
			base.Hue = 2607;
			base.Weight = 1.0;

			m_Skill = skill;
			m_Value = value;
		}
		
		[Constructable]
		public ClothingSkillScroll() : base( 0x14F0 )
		{
			base.Hue = 2607;
			base.Weight = 1.0;

			SkillName[] skills = ClothingSkillScroll.Skills;
			m_Skill = skills[Utility.Random( skills.Length )];
			m_Value = Utility.RandomList( 1, 1, 1, 1, 1, 1, 2, 2, 3 );

		}

		public ClothingSkillScroll( Serial serial ) : base( serial )
		{
		}

		[CommandProperty( AccessLevel.GameMaster )]
		public SkillName Skill
		{
			get
			{
				return m_Skill;
			}
			set
			{
				m_Skill = value;
			}
		}

		[CommandProperty( AccessLevel.GameMaster )]
		public double Value
		{
			get
			{
				return m_Value;
			}
			set
			{
				m_Value = value;
			}
		}

		public override void AddNameProperty(ObjectPropertyList list)
		{
			list.Add( "a scroll of {0} (+{1} Skill)", GetName( (int)m_Skill ), m_Value );
		}
		
		public override void GetProperties( ObjectPropertyList list )
		{
			base.GetProperties( list );
			list.Add( 1042138 ); //You can only embroider clothes with this kit.
		}

		public static string GetName( int index )
		{
			SkillInfo[] table = SkillInfo.Table;

			if ( index >= 0 && index < table.Length )
				return table[index].Name.ToLower();
			else
				return "???";
		}

		public override void OnDoubleClick( Mobile from )
		{
			if ( Deleted )
				return;
			
			if ( !IsChildOf( from.Backpack ) ) // Make sure its in their pack
			{
				from.SendLocalizedMessage( 1042001 ); // That must be in your pack for you to use it.
			}
			else
			{
				from.SendMessage( "Jake latkove obleceni chces vylepsit?" );
				from.SendMessage( "POZOR! Vylepsene obleceni budes moci pouzivat jen ty!" );
				from.Target = new InternalTarget( this );
			}
		}
		
		private class InternalTarget : Target
		{
			private ClothingSkillScroll deed;

			public InternalTarget( ClothingSkillScroll d ) : base( 1, false, TargetFlags.None )
			{
				deed = d;
			}

			protected override void OnTarget( Mobile from, object target )
			{
				if ( !( target is BaseClothing ) )
				{
					from.SendMessage( "Svitek lze pouzit pouze na latkove obleceni!" );
					return;
				}
				
				BaseClothing cloth = (BaseClothing) target;
				
				if ( !cloth.IsChildOf( from.Backpack ) )
				{
					from.SendLocalizedMessage( 1042001 ); // That must be in your pack for you to use it.
					return;
				}
				
				SkillName check;
				double bonus;
				bool isFound = false;

				for ( int i = 0; i < 5; ++i )
				{
					if ( cloth.SkillBonuses.GetValues( i, out check, out bonus ) && check == deed.Skill ) //Skill uz na itemu je
					{
						if ( bonus <= ( 10 - deed.Value ) )
						{
                     cloth.SkillBonuses.SetValues( i, deed.Skill, bonus + deed.Value );
						   isFound = true;
                  }
                  else
                  {
					       from.SendMessage("Maximalni vyska bonusu je 10");
					       return;
                  }
						break;
					}
				}
				
				if ( !isFound ) //Skill jeste neni, najdeme prvni nulovy
				{
					for ( int i = 0; i < 5; ++i )
					{
						if ( cloth.SkillBonuses.GetBonus( i ) == 0.0 )
						{
							cloth.SkillBonuses.SetValues( i, deed.Skill, deed.Value );
							isFound = true;
							break;
						}
					}
				}
				
				if ( isFound )
				{
					deed.Delete();
					Effects.SendLocationParticles( EffectItem.Create( from.Location, from.Map, EffectItem.DefaultDuration ), 0, 0, 0, 0, 0, 5060, 0 );
					Effects.PlaySound( from.Location, from.Map, 0x243 );

					Effects.SendMovingParticles( new Entity( Serial.Zero, new Point3D( from.X - 6, from.Y - 6, from.Z + 15 ), from.Map ), from, 0x36D4, 7, 0, false, true, 0x497, 0, 9502, 1, 0, (EffectLayer)255, 0x100 );
					Effects.SendMovingParticles( new Entity( Serial.Zero, new Point3D( from.X - 4, from.Y - 6, from.Z + 15 ), from.Map ), from, 0x36D4, 7, 0, false, true, 0x497, 0, 9502, 1, 0, (EffectLayer)255, 0x100 );
					Effects.SendMovingParticles( new Entity( Serial.Zero, new Point3D( from.X - 6, from.Y - 4, from.Z + 15 ), from.Map ), from, 0x36D4, 7, 0, false, true, 0x497, 0, 9502, 1, 0, (EffectLayer)255, 0x100 );

					Effects.SendTargetParticles( from, 0x375A, 35, 90, 0x00, 0x00, 9502, (EffectLayer)255, 0x100 );
					from.PlaySound( 0x1EB );
					from.SendMessage("Obleceni bylo vylepseno");
					cloth.BlessedFor = from;
				}
				else
					from.SendMessage("Obleceni se nepodarilo vylepsit");

			}
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version

			writer.Write( (int) m_Skill );
			writer.Write( (double) m_Value );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			switch ( version )
			{
				case 0:
					{
						m_Skill = (SkillName)reader.ReadInt();
						m_Value = reader.ReadDouble();

						break;
					}
			}
		}
	}
}
