using System;
using Server.Network;
using Server.Prompts;
using Server.Items;
using Server.Targeting;
using Server.Engines.XmlSpawner2;

namespace Server.Items
{
	public class DamageOil : Item
	{
      [Constructable]
		public DamageOil() : base( 3622 )
		{
			Weight = 0.1;
			Hue = 2648;
			Stackable = false;
			Name = "+1 max weapon damage oil";
			LootType = LootType.Blessed;
		}

		public DamageOil( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}

		public override bool DisplayLootType{ get{ return false; } }

		public override void OnDoubleClick( Mobile from )
		{
			if ( !IsChildOf( from.Backpack ) ) // Make sure its in their pack
			{
				from.SendLocalizedMessage( 1060640 );
			}
			else
			{
				from.SendMessage( "Vyber zbran u ktere chces pridat +1 do max damage" );
				from.Target = new DamageOilTarget( this );
			}
		}
		
		private class DamageOilTarget : Target
		{
			private DamageOil m_Oil;

			public DamageOilTarget( DamageOil deed ) : base( 1, false, TargetFlags.None )
			{
				m_Oil = deed;
			}

			protected override void OnTarget( Mobile from, object target )
			{
				if ( target is BaseWeapon )
				{
    				BaseWeapon weap = (BaseWeapon) target;
    					
    				if( !weap.IsChildOf( from.Backpack ) || !m_Oil.IsChildOf( from.Backpack ) )
    					from.SendMessage( "Musis mit olej i zbran v batohu" );
               else if( weap.BlessedFor != null && weap.BlessedFor != from )
    					from.SendMessage( "Toto neni tvoje zbran" );
    				else
    				{
    					if ( XmlAttach.FindAttachment( weap, typeof( XmlEnchantWeaponDamage ) ) != null )
    					{
                     from.SendMessage( "Olej nelze pouzit na ocarovanou zbran" );
                     return;
                  }                  
    					   
                  weap.MaxDamage  += 1;
                  from.FixedParticles( 14170, 1, 10, 0x1F78, m_Oil.Hue, 5, EffectLayer.Waist );
    					from.PlaySound( 0x1EB );
    					from.PlaySound( 480 );
    					from.SendMessage( "Zbran byla vylepsena" );
    					m_Oil.Delete();
    				}
            }
				else
				{
					from.SendMessage( "Olej lze pouzit pouze na zbrane" );
					return;
				}		

			}
		}
	}
}


