using System;
using Server.Network;
using Server.Prompts;
using Server.Items;
using Server.Targeting;

namespace Server.Items
{
	public class DyeThinner : Item
	{
		[Constructable]
		public DyeThinner() : this( 1 )
		{
		}
      
      [Constructable]
		public DyeThinner( int amount ) : base( 3854 )
		{
			Weight = 1.0;
			Hue = 2463;
			Stackable = true;
			Name = "redidlo na barvu";
			LootType = LootType.Blessed;
			Amount = amount;
		}

		public DyeThinner( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}

		public override bool DisplayLootType{ get{ return false; } }

		public override void OnDoubleClick( Mobile from )
		{
			if ( !IsChildOf( from.Backpack ) ) // Make sure its in their pack
			{
				from.SendLocalizedMessage( 1060640 );
			}
			else
			{
				from.SendMessage( "Jakou barvu chces rozredit?" );
				from.Target = new DyeThinnerTarget( this );
			}
		}
		
		private class DyeThinnerTarget : Target
		{
			private DyeThinner m_Deed;

			public DyeThinnerTarget( DyeThinner deed ) : base( 1, false, TargetFlags.None )
			{
				m_Deed = deed;
			}

			protected override void OnTarget( Mobile from, object target )
			{
				if ( !( target is AllDyeTubsAll ) )
				{
					from.SendMessage( "Redidlo lze pouzit pouze na Dye Tub [*Everything*]!" );
					return;
				}
				
				AllDyeTubsAll tub = (AllDyeTubsAll) target;
					
				if ( tub == null || !tub.Charged )
					from.SendMessage( "Nelze rozredit barvu na neomezeny pocet pouziti!" );
				else if( !tub.IsChildOf( from.Backpack ) || !m_Deed.IsChildOf( from.Backpack ) )
					from.SendMessage( "Musis mit barvu i redidlo u sebe" );
				else
				{
					m_Deed.Consume();
					tub.Charges++;
               from.FixedParticles( 14120, 1, 10, 0x1F78, tub.DyedHue, 5, EffectLayer.Waist );
					from.PlaySound( 32 );
					from.PlaySound( 574 );
					from.SendMessage("Barva byla naredena");
				}
			}
		}
	}
}


