using System;
using Server.Network;
using Server.Prompts;
using Server.Items;
using Server.Targeting;
using Server.Gumps;
using Server.Engines.XmlSpawner2;
using System.Collections;
using System.Collections.Generic;

namespace Server.Items
{
	public class ExceptionalLevelWeaponScroll : Item
	{
		[Constructable]
		public ExceptionalLevelWeaponScroll() : this( 1 )
		{
		}

		[Constructable]
		public ExceptionalLevelWeaponScroll( int amount ) : base( 8012 )
		{
			Name = "exceptional level weapon scroll";
         Weight = 1.0;
			Stackable = true;
			Amount = amount;
			Hue = 1975;
		}
		
		public override void GetProperties( ObjectPropertyList list )
		{
			base.GetProperties( list );
			list.Add( "Levelable Weapons Only\nBase Damage increase: 30%\nSpell hits & leeches increase: 50%\nWeapon Skill +20" );
		}

		public ExceptionalLevelWeaponScroll( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}

		public override bool DisplayLootType{ get{ return false; } }

		public override void OnDoubleClick( Mobile from )
		{
			if ( !IsChildOf( from.Backpack ) ) // Make sure its in their pack
			{
				from.SendLocalizedMessage( 1060640 );
			}
			else
			{
				from.SendMessage( "Vyber levelovaci zbran na urovni 25+ kterou chces vylepsit" );
				from.SendMessage( 34, "POZOR: Takto vylepsenou zbran nelze resetnout!" );
				from.Target = new InternalTarget( this );
			}
		}
		
    	private class InternalTarget : Target
    	{
    		private Item m_Deed;
    
    		public InternalTarget( Item deed ) : base( 1, false, TargetFlags.None )
    		{
    			m_Deed = deed;
    		}
    
    		protected override void OnTarget( Mobile from, object target )
    		{
            

            if ( target is Item && target is ILevelable )
    			{
               Item item = (Item)target;
               
               if( item.RootParent != from )
					    from.SendLocalizedMessage( 1060640 );//The item must be in your backpack to use it.
               else
                  from.SendGump( new InternalConfirmGump( item, m_Deed ) );
    			}
    			else
    				from.SendMessage( "Svitek lze pouzit pouze na levelovaci zbrane." );
    		}
    	}
		
		private class InternalConfirmGump : BaseConfirmGump
		{
			public override int TitleNumber{ get{ return 1075083; } } // <center>Warning!</center>
			public override int LabelNumber{ get{ return 1074975; } } // Are you sure you wish to select this?
			
			private Item m_Item;
			private Item m_Deed;
			
			public InternalConfirmGump( Item item, Item deed ) : base()
			{
				m_Item = item;
				m_Deed = deed;
			}
			
			public override void Confirm( Mobile from )
			{		
			   if ( m_Item == null || m_Item.Deleted || m_Deed == null || m_Deed.Deleted )
				  return;
				
				if ( !(m_Item is ILevelable && m_Item is BaseWeapon && ((ILevelable)m_Item).Level > 24 ) )
				{
               from.SendMessage( "Svitek lze pouzit pouze na levelovaci zbrane level 25 a vice." );
               return;
            }
            
            BaseWeapon weap = (BaseWeapon) m_Item;
            
				if ( weap.Quality == WeaponQuality.Exceptional )
				{
               from.SendMessage( "Tato zbran uz ma vyjimecnou kvalitu." );
               return;
            }
            
            weap.Quality = WeaponQuality.Exceptional;
            weap.SkillBonuses.SetValues( 4, weap.Skill, 20.0 );
            weap.BlessedFor = from;
            weap.MinDamage = AOS.Scale( weap.MinDamage, 130 );
            weap.MaxDamage = AOS.Scale( weap.MaxDamage, 130 );
            
            from.SendMessage( 33, "Zbran byla vylepsena" );
				from.FixedParticles( 0x376A, 9, 32, 5007, EffectLayer.Waist );
				from.PlaySound( 487 );

            m_Deed.Consume();
			}
		}
	}
}


