using System;

namespace Server.Items
{
	public class EyeOfNewt : Item
	{
		[Constructable]
		public EyeOfNewt() : this( 1 )
		{
		}

		[Constructable]
		public EyeOfNewt( int amount ) : base( 0x0F87 )
		{
			Weight = 1.0;
			Stackable = true;
			Amount = amount;
		}

		public EyeOfNewt( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}