using System;
using Server.Network;
using Server.Prompts;
using Server.Items;
using Server.Targeting;

namespace Server.Items
{
	public class InshaveOfBalanceTarget : Target
	{
		private InshaveOfBalance m_Inshave;

		public InshaveOfBalanceTarget( InshaveOfBalance inshave ) : base( 1, false, TargetFlags.None )
		{
			m_Inshave = inshave;
		}

		protected override void OnTarget( Mobile from, object target )
		{
			if ( target is BaseRanged )
			{
				BaseRanged item = (BaseRanged)target;
				
            if( item.RootParent != from )
					from.SendMessage( "Musis mit zbran u sebe" );
            else if( item.BlessedFor != null && item.BlessedFor != from )
					from.SendMessage( "Toto neni tvoje zbran" );
            else if( item.Balanced )
					from.SendMessage( "Tato zbran jiz vlastnost balanced obsahuje!" );
				else
				{
					item.Balanced = true;
					item.BlessedFor = from;
					item.Attributes.WeaponDamage += 20;
					from.SendMessage( "Zbran je nyni perfektne vyvazena a vylepsena." );
					m_Inshave.Delete();
				}
			}
			else
				from.SendMessage( "Nastroj lze pouzit pouze na strelne zbrane." );
		}
	}

	public class InshaveOfBalance : Item
	{
		[Constructable]
		public InshaveOfBalance() : base( 4326 )
		{
			Weight = 1.0;
			Hue = 1564;
			Name = "a inshave of balance and power";
			LootType = LootType.Blessed;
		}

		public InshaveOfBalance( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			LootType = LootType.Blessed;

			int version = reader.ReadInt();
		}

		public override void OnDoubleClick( Mobile from )
		{
			if ( !IsChildOf( from.Backpack ) ) // Make sure its in their pack
			{
				from.SendLocalizedMessage( 1060640 );
			}
			else
			{
				from.SendMessage( "Do jake strelne zbrane chces pridat vlastnost balanced?" );
				from.SendMessage( 33, "POZOR! Zbran, kterou vylepsis budes moci pouzivat jen ty!" );
				from.Target = new InshaveOfBalanceTarget( this );
			}
		}
	}
}


