using System;
using Server.Network;
using Server.Prompts;
using Server.Items;
using Server.Targeting;

namespace Server.Items
{
	public class BlessTarget : Target // Create our targeting class (which we derive from the base target class)
	{
		private ItemBlessDeed m_Deed;

		public BlessTarget( ItemBlessDeed deed ) : base( 1, false, TargetFlags.None )
		{
			m_Deed = deed;
		}

		protected override void OnTarget( Mobile from, object target ) // Override the protected OnTarget() for our feature
		{
			if ( target is BaseWeapon || target is BaseArmor || target is BaseJewel || target is BaseClothing || target is BaseQuiver || target is BaseTalisman || target is FishingPole )
			{
				Item item = (Item)target;

				if ( item.LootType == LootType.Blessed || item.BlessedFor != null || item.Insured || item.LootType == LootType.Newbied ) // Check if its already newbied (blessed)
				{
					from.SendLocalizedMessage( 1045113 ); // That item is already blessed
				}
				else if ( item.LootType != LootType.Regular )
				{
					from.SendLocalizedMessage( 1045114 ); // You can not bless that item
				}
				else
				{
					if( item.RootParent != from ) // Make sure its in their pack or they are wearing it
					{
						from.SendLocalizedMessage( 500508 ); // You may only bless objects that you are carrying.
					}
					else
					{
						item.LootType = LootType.Blessed;
						from.SendLocalizedMessage( 1010026 ); //You have blessed the item. The item cannot be stolen, and it will remain with you if you die.

						m_Deed.Delete(); // Delete the bless deed
					}
				}
			}
			else
			{
				from.SendLocalizedMessage( 500509 ); // You cannot bless that object
			}
		}
	}

	public class ItemBlessDeed : Item // Create the item class which is derived from the base item class
	{
		[Constructable]
		public ItemBlessDeed() : base( 0x14F0 )
		{
			Weight = 1.0;
			Hue = 310;				//change hue
			Name = "an item bless deed";
			LootType = LootType.Blessed;
		}

		public ItemBlessDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			LootType = LootType.Blessed;

			int version = reader.ReadInt();
		}

		public override bool DisplayLootType{ get{ return false; } }

		public override void OnDoubleClick( Mobile from ) // Override double click of the deed to call our target
		{
			if ( !IsChildOf( from.Backpack ) ) // Make sure its in their pack
			{
				from.SendLocalizedMessage( 1060640 ); // That must be in your pack for you to use it.
			}
			else
			{
				from.SendLocalizedMessage( 1045106 ); //Target the item you wish to bless.
				from.Target = new BlessTarget( this ); // Call our target
			}
		}
	}
}


