using System;
using Server.Network;
using Server.Prompts;
using Server.Items;
using Server.Targeting;
using Server.Gumps;

namespace Server.Items
{
	public class JewelryPolishingSolution : Item
	{
		private static SkillName[] m_PossibleBonusSkills = new SkillName[]
		{
			SkillName.Swords,
			SkillName.Fencing,
			SkillName.Macing,
			SkillName.Archery,
			SkillName.Wrestling,
			SkillName.Parry,
			SkillName.Tactics,
			SkillName.Anatomy,
			SkillName.Healing,
			SkillName.Magery,
			SkillName.Meditation,
			SkillName.EvalInt,
			SkillName.MagicResist,
			SkillName.AnimalTaming,
			SkillName.AnimalLore,
			SkillName.Veterinary,
			SkillName.Musicianship,
			SkillName.Provocation,
			SkillName.Discordance,
			SkillName.Peacemaking,
			SkillName.Chivalry,
			SkillName.Focus,
			SkillName.Necromancy,
			SkillName.Stealing,
			SkillName.Stealth,
			SkillName.SpiritSpeak,
			SkillName.Bushido,
			SkillName.Ninjitsu,
			SkillName.Spellweaving
		};
		
		[Constructable]
		public JewelryPolishingSolution() : this( 1 )
		{
		}
		
		[Constructable]
		public JewelryPolishingSolution( int amount ) : base( 3854 )
		{
			Weight = 1.0;
			Hue = 2560;
			Name = "Jewelry Polishing Solution";
			LootType = LootType.Blessed;
			Stackable = true;
			Amount = amount;
		}

		public JewelryPolishingSolution( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			LootType = LootType.Blessed;

			int version = reader.ReadInt();
		}

		public override bool DisplayLootType{ get{ return false; } }

		public override void OnDoubleClick( Mobile from ) // Override double click of the deed to call our target
		{
			if ( !IsChildOf( from.Backpack ) ) // Make sure its in their pack
				from.SendLocalizedMessage( 1060640 ); // That must be in your pack for you to use it.
			else
			{
				from.SendMessage( "Vyber sperk, ktery chces vylestit!" );
				from.SendMessage( 33, "POZOR! Sperk, ktery vylepsis budes moci pouzivat jen ty!" );
				from.Target = new JewelryEnchantingTarget( this ); // Call our target
			}
		}
		
		private class JewelryEnchantingTarget : Target // Create our targeting class (which we derive from the base target class)
		{
			private JewelryPolishingSolution m_Deed;

			public JewelryEnchantingTarget( JewelryPolishingSolution deed ) : base( 1, false, TargetFlags.None )
			{
				m_Deed = deed;
			}

			protected override void OnTarget( Mobile from, object target )
			{
				if ( /*target is ILevelable ||*/ !( target is BaseJewel ) )
				{
					from.SendMessage( "Roztok lze pouzit pouze na sperky!" );
					return;
            }
					
				Item jewel = (Item) target;
				
				if( !jewel.IsChildOf( from.Backpack ) )
					from.SendMessage( "Sperk musis mit v batohu" );
				else if( jewel.BlessedFor != null && jewel.BlessedFor != from )
					from.SendMessage( "Toto neni tvuj sperk" );
// 				else if ( ((BaseJewel)jewel).ArtifactRarity > 0 )
// 					from.SendMessage( "Nelze vylepsit artefakty" );
				else
				{
					from.CloseGump(typeof(JewelryPolishingSolutionGump));
					from.SendGump( new JewelryPolishingSolutionGump( from, m_Deed, (BaseJewel) jewel ) );
				}
			}
		}
		
		private class JewelryPolishingSolutionGump : Gump
		{
			private const int FieldsPerPage = 14;
			private const int maxBonus = 10;

			private JewelryPolishingSolution m_scroll;
			private BaseJewel m_jewel;

			public JewelryPolishingSolutionGump( Mobile from, JewelryPolishingSolution scroll, BaseJewel jewel )
				: base(20, 30)
			{
				m_scroll = scroll;
				m_jewel = jewel;

				AddPage(0);
				AddBackground(0, 0, 260, 351, 5054);

				AddImageTiled(10, 10, 240, 23, 0x52);
				AddImageTiled(11, 11, 238, 21, 0xBBC);

				AddLabel(15, 11, 0, "Skilly ktere lze u sperku zvysit:");

				AddPage(1);

				int page = 1;
				int index = 0;
				
				bool allBonuses = ( m_jewel.SkillBonuses.GetBonus(0) > 0 && m_jewel.SkillBonuses.GetBonus(1) > 0 &&
				                   m_jewel.SkillBonuses.GetBonus(2) > 0 && m_jewel.SkillBonuses.GetBonus(3) > 0 && m_jewel.SkillBonuses.GetBonus(4) > 0 );

				for (int i = 0; i < m_PossibleBonusSkills.Length; ++i)
				{
					if (index >= FieldsPerPage)
					{
						AddButton(231, 13, 0x15E1, 0x15E5, 0, GumpButtonType.Page, page + 1);

						++page;
						index = 0;

						AddPage(page);

						AddButton(213, 13, 0x15E3, 0x15E7, 0, GumpButtonType.Page, page - 1);
					}

					SkillName skill = m_PossibleBonusSkills[i];
					int bonus = GetSkillBonus( m_jewel.SkillBonuses, skill );

					if ( !allBonuses || ( allBonuses && bonus > 0 ) )
					{
						AddImageTiled(10, 32 + (index * 22), 240, 23, 0x52);
						AddImageTiled(11, 33 + (index * 22), 238, 21, 0xBBC);

						AddLabelCropped(13, 33 + (index * 22), 150, 21, 0, from.Skills[skill].Name);
						AddImageTiled(180, 34 + (index * 22), 50, 19, 0x52);
						AddImageTiled(181, 35 + (index * 22), 48, 17, 0xBBC);
						AddLabelCropped(182, 35 + (index * 22), 234, 21, 0, bonus.ToString());

						//if ( ( allBonuses && ( bonus < maxBonus && bonus > 0 ) ) || ( !allBonuses && bonus < maxBonus ) )
						if ( bonus < maxBonus )
							AddButton(231, 35 + (index * 22), 0x15E1, 0x15E5, i + 1, GumpButtonType.Reply, 0);

						++index;
					}
				}
			}
			
			private static int GetSkillBonus( AosSkillBonuses attrs, SkillName sk )
			{
				SkillName check;
				double bonus;

				for ( int i = 0; i < 5; ++i )
					if ( attrs.GetValues( i, out check, out bonus ) && check == sk )
					return (int) bonus;
				
				return 0;
			}

			public override void OnResponse(NetState state, RelayInfo info)
			{
				Mobile from = state.Mobile;

				if ( from == null || m_jewel == null || m_jewel.Deleted )
					return;

				if ( m_scroll == null || m_scroll.Deleted || !m_scroll.IsChildOf(from.Backpack) || m_jewel.RootParent != from )
				{
					from.SendLocalizedMessage(1042001); // That must be in your pack for you to use it.
					from.CloseGump(typeof(JewelryPolishingSolutionGump));
					return;
				}

				if (info.ButtonID > 0)
				{
					if ( (info.ButtonID - 1) >= m_PossibleBonusSkills.Length )
					 return;
               
               SkillName m_Skill = m_PossibleBonusSkills[(info.ButtonID - 1)];

					if (m_Skill == null)
						return;
					
					SkillName check;
					double bonus;
					bool isFound = false;

					for ( int i = 0; i < 5; ++i )
					{
						if ( m_jewel.SkillBonuses.GetValues( i, out check, out bonus ) && check == m_Skill ) //Skill uz na itemu je
						{
    						if ( bonus < maxBonus )
    						{
                        m_jewel.SkillBonuses.SetValues( i, m_Skill, bonus + 1.0 );
                        isFound = true;
                      }
                      else
                      {
    					       from.SendMessage("Maximalni vyska bonusu je {0}", maxBonus);
    					       return;
                      }
    						break;
						}
					}
					
					if ( !isFound ) //Skill jeste neni, najdeme prvni nulovy
					{
						for ( int i = 0; i < 5; ++i )
						{
							if ( ( bonus = m_jewel.SkillBonuses.GetBonus( i ) ) == 0.0 )
							{
								m_jewel.SkillBonuses.SetValues( i, m_Skill, 1.0 );
								isFound = true;
								break;
							}
						}
					}
					
					if ( isFound )
					{
						m_scroll.Consume();
						from.FixedParticles( 0x375A, 10, 15, 5011, EffectLayer.Head );
						from.PlaySound( 0x1EB );
						from.SendMessage("Sperk byl vylesten");
						m_jewel.BlessedFor = from;
					}
					else
						from.SendMessage("Sperk se nepodarilo vylepsit (ERROR 01)");
				}
			}
		}
	}
}