using System;
using Server.Network;
using Server.Prompts;
using Server.Items;
using Server.Targeting;

namespace Server.Items
{
	public class LestidloNaBotySDI : Item
	{
		[Constructable]
		public LestidloNaBotySDI() : this( 1 )
		{
		}

		[Constructable]
		public LestidloNaBotySDI( int amount ) : base( 2540 )
		{
			Name = "lestidlo na boty";
         Weight = 1.0;
			Stackable = true;
			Amount = amount;
			Hue = 583;
		}
		
		public override void GetProperties( ObjectPropertyList list )
		{
			base.GetProperties( list );
			list.Add( "Spell damage cap increase" );
		}

		public LestidloNaBotySDI( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}

		public override bool DisplayLootType{ get{ return false; } }

		public override void OnDoubleClick( Mobile from )
		{
			if ( !IsChildOf( from.Backpack ) ) // Make sure its in their pack
			{
				from.SendLocalizedMessage( 1060640 );
			}
			else
			{
				from.SendMessage( "Ktere boty chces vylestit?" );
				from.Target = new InternalTarget( this );
			}
		}
		
    	private class InternalTarget : Target
    	{
    		private Item m_Deed;
    
    		public InternalTarget( Item deed ) : base( 1, false, TargetFlags.None )
    		{
    			m_Deed = deed;
    		}
    
    		protected override void OnTarget( Mobile from, object target )
    		{
            if ( m_Deed == null || m_Deed.Deleted || from == null )
               return;
            
            if ( target is BaseShoes )
    			{
               BaseShoes shoes = (BaseShoes)target;
               
               if( !shoes.IsChildOf( from.Backpack ) || !m_Deed.IsChildOf( from.Backpack ) )
					    from.SendLocalizedMessage( 1060640 );//The item must be in your backpack to use it.
					else if ( shoes.SDIBonus >= 50 )
                  from.SendMessage( "maximalni bonus je 50" );
               else
               {
                  shoes.Quality = ClothingQuality.Exceptional;
                  shoes.SDIBonus++;
                  
                  from.SendMessage( 33, "Boty byly vylesteny" );
      				from.FixedParticles( 0x376A, 9, 32, 5007, EffectLayer.Waist );
      				from.PlaySound( 487 );
      
                  m_Deed.Consume();
               }
    			}
            else if ( target is BaseLevelShoes )
    			{
               BaseLevelShoes shoes = (BaseLevelShoes)target;
               
               if( !shoes.IsChildOf( from.Backpack ) || !m_Deed.IsChildOf( from.Backpack ) )
					    from.SendLocalizedMessage( 1060640 );//The item must be in your backpack to use it.
					else if ( shoes.SDIBonus >= 50 )
                  from.SendMessage( "maximalni bonus je 50" );
               else
               {
                  shoes.Quality = ClothingQuality.Exceptional;
                  shoes.SDIBonus++;
                  
                  from.SendMessage( 33, "Boty byly vylesteny" );
      				from.FixedParticles( 0x376A, 9, 32, 5007, EffectLayer.Waist );
      				from.PlaySound( 487 );
      
                  m_Deed.Consume();
               }
    			}
    			else
    				from.SendMessage( "Lestidlo lze pouzit pouze na boty" );
    		}
    	}
	}
}


