using System;
using Server.Network;
using Server.Prompts;
using Server.Items;
using Server.Targeting;

namespace Server.Items
{
	public class MageArmorTarget : Target
	{
		private MageArmorScroll m_Scroll;

		public MageArmorTarget( MageArmorScroll scroll ) : base( 1, false, TargetFlags.None )
		{
			m_Scroll = scroll;
		}

		protected override void OnTarget( Mobile from, object target )
		{
			if ( target is ILevelable )
            from.SendMessage( "Olej nelze pouzit na levelovaci predmety!" );
         else if ( target is BaseArmor && !(target is BaseShield) )
			{
				BaseArmor item = (BaseArmor)target;
				
            if( item.RootParent != from )
					from.SendMessage( "Musis mit predmet u sebe" );
            else if( item.BlessedFor != null && item.BlessedFor != from )
					from.SendMessage( "Toto neni tvuj predmet" );
            else if( item.ArmorAttributes.MageArmor > 0 )
					from.SendMessage( "Toto brneni jiz vlastnost mage armor obsahuje!" );
				else
				{
					item.ArmorAttributes.MageArmor = 1;
					item.BlessedFor = from;
					from.SendMessage( "Vlastnost Mage Armor byla uspesne pridana." );
					m_Scroll.Delete();
				}
			}
			else
				from.SendMessage( "Svitek lze pouzit pouze na brneni." );
		}
	}

	public class MageArmorScroll : Item
	{
		[Constructable]
		public MageArmorScroll() : base( 5357 )
		{
			Weight = 1.0;
			Hue = 88;
			Name = "a mage armor scroll";
			LootType = LootType.Blessed;
		}

		public MageArmorScroll( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			LootType = LootType.Blessed;

			int version = reader.ReadInt();
		}

		public override bool DisplayLootType{ get{ return false; } }

		public override void OnDoubleClick( Mobile from )
		{
			if ( !IsChildOf( from.Backpack ) ) // Make sure its in their pack
			{
				from.SendLocalizedMessage( 1060640 );
			}
			else
			{
				from.SendMessage( "Do jakeho brneni chces pridat vlastnost Mage Armor?" );
				from.SendMessage( 33, "POZOR! Brneni, ktere vylepsis budes moci pouzivat jen ty!" );
				from.Target = new MageArmorTarget( this );
			}
		}
	}
}


