using System;
using Server.Network;
using Server.Prompts;
using Server.Items;
using Server.Targeting;

namespace Server.Items
{
	public class MagicScrollTarget : Target
	{
		private MagicScroll m_Scroll;

		public MagicScrollTarget( MagicScroll scroll ) : base( 1, false, TargetFlags.None )
		{
			m_Scroll = scroll;
		}
		
		private void DamageScroll( Mobile from )
		{
			if ( m_Scroll.ScrollValue > 1 )
			{
            from.SendMessage( "Predmet se nepodarilo vylepsit a svitek byl poskozen!" );
			   m_Scroll.ScrollValue -= 1;
         }
         else
         {
            from.SendMessage( "Predmet se nepodarilo vylepsit a svitek byl znicen!" );
			   m_Scroll.Delete();
         }
         
			from.PlaySound( 0x307 );
			from.FixedParticles( 0x36BD, 20, 10, 5044, EffectLayer.Head );
      }

		protected override void OnTarget( Mobile from, object target )
		{
			if ( target is MagicScroll && target != m_Scroll )
			{
				MagicScroll TargetScroll = (MagicScroll) target;
				
				if ( !TargetScroll.IsChildOf( from.Backpack ) )
					from.SendLocalizedMessage( 1042001 );
				else if ( m_Scroll.MagicScrollType == TargetScroll.MagicScrollType )
				{
					m_Scroll.ScrollValue += TargetScroll.ScrollValue;
					TargetScroll.Delete();
					from.SendMessage( "Svitky byly magicky spojeny." );
				}
				else
					from.SendMessage( "Pouze dva stejne svitky lze spojit!" );
			}
			else
			{
				double ch = MagicScroll.GetChance( from );
				
				if ( from.AccessLevel < AccessLevel.GameMaster && ch > 0.6 )
				  ch = 0.6; //maximalni sance na uspech 60%
				
            bool chance = ( Utility.RandomDouble() < ch );
            
            if ( target is ILevelable )
					from.SendMessage( "Svitek nelze pouzit na levelovaci predmety!" );
				else if ( (int) m_Scroll.MagicScrollType > 16 && !( target is Spellbook ) )
					from.SendMessage( "Tento svitek lze pouzit pouze na Spellbook" );
				else if ( target is BaseWeapon )
				{
					BaseWeapon item = (BaseWeapon)target;
					
					if( item.RootParent != from )
						from.SendMessage( "Zbran musis mit u sebe" );
					else if( item.BlessedFor != null && item.BlessedFor != from )
						from.SendMessage( "Toto neni tvuj predmet" );
					else
					{
						if ( chance )
						{
							if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.WeaponDamage )
								item.Attributes.WeaponDamage += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.DefendChance )
								item.Attributes.DefendChance += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.AttackChance )
								item.Attributes.AttackChance += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.Luck )
								item.Attributes.Luck += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.WeaponSpeed )
								item.Attributes.WeaponSpeed += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusHits )
								item.Attributes.BonusHits += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusMana )
								item.Attributes.BonusMana += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusStam )
								item.Attributes.BonusStam += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.RegenHits )
								item.Attributes.RegenHits += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.RegenMana )
								item.Attributes.RegenMana += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.RegenStam)
								item.Attributes.RegenStam += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.SpellDamage )
								item.Attributes.SpellDamage += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusStr )
								item.Attributes.BonusStr += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusDex )
								item.Attributes.BonusDex += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusInt )
								item.Attributes.BonusInt += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.CastRecovery )
								item.Attributes.CastRecovery += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.CastSpeed )
								item.Attributes.CastSpeed += m_Scroll.ScrollValue;
							
							from.SendMessage( "Zbran byla vylepsena!" );
							item.BlessedFor = from;
							m_Scroll.Delete();
						}
						else
						{
							if ( Utility.RandomDouble() > 0.80 )
								from.SendMessage( "Zbran se nepodarilo vylepsit." );
							else
							{
								DamageScroll( from );
							}
						}
					}
				}
				else if ( target is BaseArmor )
				{
					BaseArmor item = (BaseArmor)target;
					
					if( item.RootParent != from )
						from.SendMessage( "Brneni musis mit u sebe" );
					else if( item.BlessedFor != null && item.BlessedFor != from )
						from.SendMessage( "Toto neni tvuj predmet" );
					else
					{
						if ( chance )
						{
							if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.WeaponDamage )
								item.Attributes.WeaponDamage += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.DefendChance )
								item.Attributes.DefendChance += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.AttackChance )
								item.Attributes.AttackChance += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.Luck )
								item.Attributes.Luck += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.WeaponSpeed )
								item.Attributes.WeaponSpeed += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusHits )
								item.Attributes.BonusHits += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusMana )
								item.Attributes.BonusMana += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusStam )
								item.Attributes.BonusStam += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.RegenHits )
								item.Attributes.RegenHits += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.RegenMana )
								item.Attributes.RegenMana += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.RegenStam)
								item.Attributes.RegenStam += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.SpellDamage )
								item.Attributes.SpellDamage += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusStr )
								item.Attributes.BonusStr += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusDex )
								item.Attributes.BonusDex += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusInt )
								item.Attributes.BonusInt += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.CastRecovery )
								item.Attributes.CastRecovery += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.CastSpeed )
								item.Attributes.CastSpeed += m_Scroll.ScrollValue;
							
							from.SendMessage( "Brneni bylo vylepseno!" );
							item.BlessedFor = from;
							m_Scroll.Delete();
						}
						else
						{
							if ( Utility.RandomDouble() > 0.80 )
								from.SendMessage( "Brneni se nepodarilo vylepsit." );
							else
							{
								DamageScroll( from );
							}
						}
					}
				}
				else if ( target is BaseJewel )
				{
					BaseJewel item = (BaseJewel)target;
					
					if( item.RootParent != from )
						from.SendMessage( "Sperk musis mit u sebe" );
					else if( item.BlessedFor != null && item.BlessedFor != from )
						from.SendMessage( "Toto neni tvuj predmet" );
					else
					{
						if ( chance )
						{
							if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.WeaponDamage )
								item.Attributes.WeaponDamage += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.DefendChance )
								item.Attributes.DefendChance += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.AttackChance )
								item.Attributes.AttackChance += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.Luck )
								item.Attributes.Luck += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.WeaponSpeed )
								item.Attributes.WeaponSpeed += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusHits )
								item.Attributes.BonusHits += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusMana )
								item.Attributes.BonusMana += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusStam )
								item.Attributes.BonusStam += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.RegenHits )
								item.Attributes.RegenHits += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.RegenMana )
								item.Attributes.RegenMana += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.RegenStam)
								item.Attributes.RegenStam += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.SpellDamage )
								item.Attributes.SpellDamage += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusStr )
								item.Attributes.BonusStr += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusDex )
								item.Attributes.BonusDex += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusInt )
								item.Attributes.BonusInt += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.CastRecovery )
								item.Attributes.CastRecovery += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.CastSpeed )
								item.Attributes.CastSpeed += m_Scroll.ScrollValue;
							
							from.SendMessage( "Sperk byl vylepsen!" );
							item.BlessedFor = from;
							m_Scroll.Delete();
						}
						else
						{
							if ( Utility.RandomDouble() > 0.80 )
								from.SendMessage( "Sperk se nepodarilo vylepsit." );
							else
							{
								DamageScroll( from );
							}
						}
					}
				}
				else if ( target is BaseClothing )
				{
					BaseClothing item = (BaseClothing)target;
					
					if( item.RootParent != from )
						from.SendMessage( "Obleceni musis mit u sebe" );
					else if( item.BlessedFor != null && item.BlessedFor != from )
						from.SendMessage( "Toto neni tvuj predmet" );
					else
					{
						if ( chance )
						{
							if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.WeaponDamage )
								item.Attributes.WeaponDamage += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.DefendChance )
								item.Attributes.DefendChance += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.AttackChance )
								item.Attributes.AttackChance += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.Luck )
								item.Attributes.Luck += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.WeaponSpeed )
								item.Attributes.WeaponSpeed += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusHits )
								item.Attributes.BonusHits += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusMana )
								item.Attributes.BonusMana += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusStam )
								item.Attributes.BonusStam += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.RegenHits )
								item.Attributes.RegenHits += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.RegenMana )
								item.Attributes.RegenMana += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.RegenStam)
								item.Attributes.RegenStam += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.SpellDamage )
								item.Attributes.SpellDamage += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusStr )
								item.Attributes.BonusStr += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusDex )
								item.Attributes.BonusDex += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusInt )
								item.Attributes.BonusInt += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.CastRecovery )
								item.Attributes.CastRecovery += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.CastSpeed )
								item.Attributes.CastSpeed += m_Scroll.ScrollValue;
							
							from.SendMessage( "Obleceni bylo vylepseno!" );
							item.BlessedFor = from;
							m_Scroll.Delete();
						}
						else
						{
							if ( Utility.RandomDouble() > 0.80 )
								from.SendMessage( "Obleceni se nepodarilo vylepsit." );
							else
							{
								DamageScroll( from );
							}
						}
					}
				}
				else if ( target is Spellbook )
				{
					Spellbook item = (Spellbook)target;
					
					if( item.RootParent != from )
						from.SendMessage( "Knihu musis mit u sebe" );
					else if( item.BlessedFor != null && item.BlessedFor != from )
						from.SendMessage( "Toto neni tvuj predmet" );
					else
					{
						if ( chance )
						{
							if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.WeaponDamage )
								item.Attributes.WeaponDamage += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.DefendChance )
								item.Attributes.DefendChance += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.AttackChance )
								item.Attributes.AttackChance += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.Luck )
								item.Attributes.Luck += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.WeaponSpeed )
								item.Attributes.WeaponSpeed += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusHits )
								item.Attributes.BonusHits += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusMana )
								item.Attributes.BonusMana += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusStam )
								item.Attributes.BonusStam += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.RegenHits )
								item.Attributes.RegenHits += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.RegenMana )
								item.Attributes.RegenMana += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.RegenStam)
								item.Attributes.RegenStam += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.SpellDamage )
								item.Attributes.SpellDamage += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusStr )
								item.Attributes.BonusStr += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusDex )
								item.Attributes.BonusDex += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.BonusInt )
								item.Attributes.BonusInt += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.CastRecovery )
								item.Attributes.CastRecovery += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.CastSpeed )
								item.Attributes.CastSpeed += m_Scroll.ScrollValue;
							//Spellbook only	
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.CritChance )
							{
								if ( item.CritChance > 19 )
								{
                           from.SendMessage( "Maximalni hodnota critical spell chance je 20" );
                           return;
                        }
                        
                        item.CritChance += m_Scroll.ScrollValue;
                     }
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.CritDamage )
								item.CritDamage += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.ConsecrateChance )
								item.ConsecrateChance += m_Scroll.ScrollValue;
							else if ( m_Scroll.MagicScrollType == MagicScroll.ScrollType.LeechChance )
								item.LeechChance += m_Scroll.ScrollValue;
							
							from.SendMessage( "Kniha byla vylepsena!" );
							item.BlessedFor = from;
							m_Scroll.Delete();
						}
						else
						{
							if ( Utility.RandomDouble() > 0.80 )
								from.SendMessage( "Knihu se nepodarilo vylepsit." );
							else
							{
								DamageScroll( from );
							}
						}
					}
				}
				else
					from.SendMessage( "Na tohle se svitek neda pouzit." );
			}
		}
	}
	
	
	
	public class MagicScroll : Item
	{
		// mozne vlastnosti svitku
		public enum ScrollType {
			Luck,
			RegenHits,
			RegenMana,
			RegenStam,
			BonusHits,
			BonusMana,
			BonusStam,
			SpellDamage,
			WeaponDamage,
			WeaponSpeed,
			DefendChance,
			AttackChance,
			BonusStr,
			BonusDex,
			BonusInt,
			CastRecovery,
			CastSpeed,
			//Spellbook only
			CritChance, //17
			CritDamage,
			ConsecrateChance,
			LeechChance
		}

		private ScrollType m_ScrollType;
		private int scrollValue;
		
		[CommandProperty( AccessLevel.GameMaster )]
		public ScrollType MagicScrollType  {
			get { return m_ScrollType; }
			set {
				m_ScrollType = value;
				InvalidateProperties();
			}
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int ScrollValue  {
			get { return scrollValue; }
			set {
				scrollValue = value;
				if ( scrollValue < 1 ) scrollValue = 1;
				InvalidateProperties();
			}
		}
		
		[Constructable]
		public MagicScroll() : this( 1, false )
		{
		}
		
		[Constructable]
		public MagicScroll( int value ) : this( value, false )
		{
		}
		
		[Constructable]
		public MagicScroll( int value, bool spellbook ) : base( 0x14F0 )
		{
			Weight = 1.0;
			LootType = LootType.Blessed;
			ScrollValue = value;
			m_ScrollType = RandomScrollType( spellbook );
			Name = "Magical Scroll";
			Hue = 1573;
		}
		
		private static ScrollType RandomScrollType( bool spellbook )
		{
			ScrollType rndScroll = ScrollType.Luck;
			
			if ( spellbook )
			{
    			switch( Utility.Random( 4 ) )
    			{
    					case 0: rndScroll = ScrollType.CritChance; break;
    					case 1: rndScroll = ScrollType.CritDamage; break;
    					case 2: rndScroll = ScrollType.ConsecrateChance; break;
    					case 3: rndScroll = ScrollType.LeechChance; break;
    			}
			
			   return rndScroll;
         }
			
			switch( Utility.Random( 17 ) )
			{
					case 0: rndScroll = ScrollType.Luck; break;
					case 1: rndScroll = ScrollType.RegenHits; break;
					case 2: rndScroll = ScrollType.RegenMana; break;
					case 3: rndScroll = ScrollType.RegenStam; break;
					case 4: rndScroll = ScrollType.BonusHits; break;
					case 5: rndScroll = ScrollType.BonusMana; break;
					case 6: rndScroll = ScrollType.BonusStam; break;
					case 7: rndScroll = ScrollType.SpellDamage; break;
					case 8: rndScroll = ScrollType.WeaponDamage; break;
					case 9: rndScroll = ScrollType.WeaponSpeed; break;
					case 10: rndScroll = ScrollType.DefendChance; break;
					case 11: rndScroll = ScrollType.AttackChance; break;
					case 12: rndScroll = ScrollType.BonusStr; break;
					case 13: rndScroll = ScrollType.BonusDex; break;
					case 14: rndScroll = ScrollType.BonusInt; break;
					case 15: rndScroll = ScrollType.CastRecovery; break;
					case 16: rndScroll = ScrollType.CastSpeed; break;
			}
			
			return rndScroll;
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			if (m_ScrollType == ScrollType.WeaponDamage)
				list.Add(1060401, scrollValue.ToString()); // damage increase +~1_val~%
			
			if (m_ScrollType == ScrollType.DefendChance)
				list.Add(1060408, scrollValue.ToString()); // defend chance +~1_val~%
			
			if (m_ScrollType == ScrollType.AttackChance)
				list.Add(1060415, scrollValue.ToString()); // hit chance +~1_val~%
			
			if (m_ScrollType == ScrollType.BonusHits)
				list.Add(1060431, scrollValue.ToString()); // hit points increase +~1_val~%
			
			if (m_ScrollType == ScrollType.BonusMana)
				list.Add(1060439, scrollValue.ToString()); // mana increase +~1_val~%
			
			if (m_ScrollType == ScrollType.BonusStam)
				list.Add(1060484, scrollValue.ToString()); // stamina increate ~1_val~%

			if (m_ScrollType == ScrollType.RegenHits)
				list.Add(1060444, scrollValue.ToString()); // hit points regeneration ~1_val~%

			if (m_ScrollType == ScrollType.RegenMana)
				list.Add(1060440, scrollValue.ToString()); // mana regeneration ~1_val~%

			if (m_ScrollType == ScrollType.RegenStam)
				list.Add(1060443, scrollValue.ToString()); // stamina regeneration ~1_val~%

			if (m_ScrollType == ScrollType.SpellDamage)
				list.Add(1060483, scrollValue.ToString()); // spell damage increase ~1_val~%

			if (m_ScrollType == ScrollType.WeaponSpeed)
				list.Add(1060486, scrollValue.ToString()); // swing speed increase ~1_val~%

			if (m_ScrollType == ScrollType.Luck)
				list.Add(1060436, scrollValue.ToString()); // luck ~1_val~%

			if (m_ScrollType == ScrollType.BonusStr)
				list.Add(1060485, scrollValue.ToString()); // bonus str ~1_val~%

			if (m_ScrollType == ScrollType.BonusDex)
				list.Add(1060409, scrollValue.ToString()); // bonus dex ~1_val~%

			if (m_ScrollType == ScrollType.BonusInt)
				list.Add(1060432, scrollValue.ToString()); // bonus int ~1_val~%
			
			if (m_ScrollType == ScrollType.CastRecovery)
				list.Add(1060412, scrollValue.ToString()); // faster cast recovery ~1_val~

			if (m_ScrollType == ScrollType.CastSpeed)
				list.Add(1060413, scrollValue.ToString()); // faster casting ~1_val~
				
			if (m_ScrollType == ScrollType.CritChance)
				list.Add( 1060658, "{0}\t{1}", "critical spell chance", scrollValue.ToString() + "%" );
				
			if (m_ScrollType == ScrollType.CritDamage)
				list.Add( 1060658, "{0}\t{1}", "spell critical damage increase", scrollValue.ToString() + "%" );
				
			if (m_ScrollType == ScrollType.ConsecrateChance)
				list.Add( 1060658, "{0}\t{1}", "consecrated spell chance", scrollValue.ToString() + "%" );
				
			if (m_ScrollType == ScrollType.LeechChance)
				list.Add( 1060658, "{0}\t{1}", "spell life leech chance", scrollValue.ToString() + "%" );
		}
		
		public static double GetChance( Mobile from )
		{
			double chance = 0.05 + ((from.Skills[SkillName.Inscribe].Value - 75.0) / (190.0 - 75.0) * (1.0 - 0.05)) - 0.05;
			
			/*if ( from.Skills[SkillName.Inscribe].Value > 74.9 && from.Talisman is BaseTalisman )
			{
				BaseTalisman talisman = (BaseTalisman) from.Talisman;
				
				if ( talisman.Skill == SkillName.Inscribe )
					chance += talisman.SuccessBonus / (double) 100;
			}*/
			
			chance += Math.Min( 0.05, ( (double) Guilds.Guild.GetLevel( from ) ) / 1000.0 );
			
			if ( chance < 0.0 ) chance = 0.0;
			else if ( chance > 1.0 ) chance = 1.0;
			
			return ( ( from.AccessLevel >= AccessLevel.GameMaster ) ? 1.0 : chance );
		}

		public MagicScroll( Serial serial ) : base( serial )
		{
		}

		// nezobrazi blessed, insured nebo cursed
		public override bool DisplayLootType{ get{ return false; } }
		// nezobrazi vahu
		public override bool DisplayWeight { get { return false; } }
		
		public override void OnDoubleClick( Mobile from ) {
			// item musi byt v baglu
			if ( this.RootParent != from )
				from.SendLocalizedMessage( 1042010 ); // You must have the object in your backpack to use it.
			else {
				from.SendMessage( "Zamer predmet ktery chces vylepsit, nebo svitek ktery chces spojit." );
				from.SendMessage( 33, "POZOR! Predmet, ktery vylepsis budes moci pouzivat jen ty!" );
				from.SendMessage( 61, "Sance na vylepseni: {0:F1}%", GetChance( from ) * 100 );
				from.Target = new MagicScrollTarget( this );
			}
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version

			writer.Write((int)m_ScrollType );
			writer.Write(scrollValue);
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			switch ( version )
			{
				case 0:
					{
						m_ScrollType = (ScrollType)reader.ReadInt();
						scrollValue = reader.ReadInt();

						break;
					}
			}
		}
	}
}
