using System;
using Server.Network;
using System.Collections;
using Server.ContextMenus;
using System.Collections.Generic;
using Server.Items;
using Server.Targeting;
using Xanthos.Evo;

namespace Server.Items
{
	public class MagicalWireTarget : Target
	{
		private MagicalWire m_Wire;

		public MagicalWireTarget( MagicalWire wire ) : base( 1, false, TargetFlags.None )
		{
			m_Wire = wire;
		}

		protected override void OnTarget( Mobile from, object target )
		{
			if ( target is MagicalWire && target != m_Wire )
			{
				MagicalWire TargetWire = (MagicalWire) target;
				
				if ( !TargetWire.IsChildOf( from.Backpack ) )
					from.SendLocalizedMessage( 1042001 );
				else if ( m_Wire.WeaponWireAttribute == TargetWire.WeaponWireAttribute )
				{
					m_Wire.Bonus += TargetWire.Bonus;
					TargetWire.Delete();
					from.SendMessage( "Skombinovano!" );
				}
				else
					from.SendMessage( "Pouze dva stejne draty lze skombinovat!" );
			}
			else
			{
				if ( target is BaseWeapon || target is EvoGolem )
				{
					BaseWeapon item = null;
					
					if ( target is EvoGolem )
					{
						item = (BaseWeapon) ((Mobile)target).Weapon;
						
						if ( item == null || item is Fists )
						{
							from.SendMessage( "Golemova zbran nebyla nalezena. Kontaktuj GM!" );
							return;
						}
						else if ( ((Mobiles.BaseCreature)target).ControlMaster != from )
						{
							from.SendMessage( "Toto neni tvuj golem" );
							return;
						}
						else
						{
							bool validWire = true;
							
							switch ( m_Wire.WeaponWireAttribute )
							{
									case MagicalWire.WireAttribute.LowerStatReq: validWire = false; break;
									case MagicalWire.WireAttribute.DurabilityBonus: validWire = false; break;
									//                 				case WireAttribute.WeaponDamage: validWire = false; break;
									//                 				case WireAttribute.DefendChance: validWire = false; break;
									//                 				case WireAttribute.AttackChance: validWire = false; break;
									//                 				case WireAttribute.Luck: validWire = false; break;
									//                 				case WireAttribute.WeaponSpeed: validWire = false; break;
							}
							
							if ( !validWire )
							{
								from.SendMessage( "Tento druh dratu nelze na golema pouzit." );
								return;
							}
						}
					}
					else
						item = (BaseWeapon)target;
					
					if( !( target is EvoGolem ) && item.RootParent != from )
						from.SendMessage( "Musis mit predmet u sebe" );
					else if( !( target is EvoGolem ) && ( item.BlessedFor != null && item.BlessedFor != from ) )
						from.SendMessage( "Toto neni tvuj predmet" );
					else if ( item.ArtifactRarity > 0 && !( item is ILevelable && item.Quality == WeaponQuality.Exceptional ) )
						from.SendMessage( "Artefakty lze vylepsit pouze levelovaci, vyjimecne kvality" );
               else if ( item is ILevelable && item.Quality != WeaponQuality.Exceptional )
						from.SendMessage( "Pouze levelovaci zbrane vyjimecne kvality lze vylepsit" );
					else
					{
      				double ch = MagicalWire.GetChance( from );
      				
      				if ( from.AccessLevel < AccessLevel.GameMaster && ch > 0.7 )
      				  ch = 0.7; //maximalni sance na uspech 70%
      				  
      				if ( target is EvoGolem )
      				  ch = 1.0; //100% sance na uspech u golema
                  
                  if ( Utility.RandomDouble() < ch )
						{
							if ( m_Wire.WeaponWireAttribute == MagicalWire.WireAttribute.WeaponDamage )
								item.Attributes.WeaponDamage += m_Wire.Bonus;
							else if ( m_Wire.WeaponWireAttribute == MagicalWire.WireAttribute.DefendChance )
								item.Attributes.DefendChance += m_Wire.Bonus;
							else if ( m_Wire.WeaponWireAttribute == MagicalWire.WireAttribute.AttackChance )
								item.Attributes.AttackChance += m_Wire.Bonus;
							else if ( m_Wire.WeaponWireAttribute == MagicalWire.WireAttribute.Luck )
								item.Attributes.Luck += m_Wire.Bonus;
							else if ( m_Wire.WeaponWireAttribute == MagicalWire.WireAttribute.WeaponSpeed )
								item.Attributes.WeaponSpeed += m_Wire.Bonus;
							else
							{
								AosWeaponAttributes attrs = item.WeaponAttributes;
								AosWeaponAttribute attr = AosWeaponAttribute.LowerStatReq;
								
								switch ( m_Wire.WeaponWireAttribute )
								{
										case MagicalWire.WireAttribute.LowerStatReq: attr = AosWeaponAttribute.LowerStatReq; break;
										case MagicalWire.WireAttribute.HitLeechHits: attr = AosWeaponAttribute.HitLeechHits; break;
										case MagicalWire.WireAttribute.HitLeechStam: attr = AosWeaponAttribute.HitLeechStam; break;
										case MagicalWire.WireAttribute.HitLeechMana: attr = AosWeaponAttribute.HitLeechMana; break;
										case MagicalWire.WireAttribute.HitLowerAttack: attr = AosWeaponAttribute.HitLowerAttack; break;
										case MagicalWire.WireAttribute.HitLowerDefend: attr = AosWeaponAttribute.HitLowerDefend; break;
										case MagicalWire.WireAttribute.HitMagicArrow: attr = AosWeaponAttribute.HitMagicArrow; break;
										case MagicalWire.WireAttribute.HitHarm: attr = AosWeaponAttribute.HitHarm; break;
										case MagicalWire.WireAttribute.HitFireball: attr = AosWeaponAttribute.HitFireball; break;
										case MagicalWire.WireAttribute.HitLightning: attr = AosWeaponAttribute.HitLightning; break;
										case MagicalWire.WireAttribute.HitDispel: attr = AosWeaponAttribute.HitDispel; break;
										case MagicalWire.WireAttribute.HitColdArea: attr = AosWeaponAttribute.HitColdArea; break;
										case MagicalWire.WireAttribute.HitFireArea: attr = AosWeaponAttribute.HitFireArea; break;
										case MagicalWire.WireAttribute.HitPoisonArea: attr = AosWeaponAttribute.HitPoisonArea; break;
										case MagicalWire.WireAttribute.HitEnergyArea: attr = AosWeaponAttribute.HitEnergyArea; break;
										case MagicalWire.WireAttribute.HitPhysicalArea: attr = AosWeaponAttribute.HitPhysicalArea; break;
										case MagicalWire.WireAttribute.ResistPhysicalBonus: attr = AosWeaponAttribute.ResistPhysicalBonus; break;
										case MagicalWire.WireAttribute.ResistFireBonus: attr = AosWeaponAttribute.ResistFireBonus; break;
										case MagicalWire.WireAttribute.ResistColdBonus: attr = AosWeaponAttribute.ResistColdBonus; break;
										case MagicalWire.WireAttribute.ResistPoisonBonus: attr = AosWeaponAttribute.ResistPoisonBonus; break;
										case MagicalWire.WireAttribute.ResistEnergyBonus: attr = AosWeaponAttribute.ResistEnergyBonus; break;
										case MagicalWire.WireAttribute.DurabilityBonus: attr = AosWeaponAttribute.DurabilityBonus; break;
								}

								attrs[ attr ] += m_Wire.Bonus;
							}
							
							if ( !( target is EvoGolem ) )
							{
								item.BlessedFor = from;
								from.SendMessage( "Zbran byla vylepsena." );
							}
							else
							{
								((Mobile)target).FixedParticles( 0x376A, 9, 32, 5007, EffectLayer.Waist );
								((Mobile)target).UpdateResistances();
								
								from.SendMessage( "Golemova zbran byla vylepsena." );
								
								if ( from.AccessLevel >= AccessLevel.GameMaster )
									from.SendMessage( "Jmeno zbrane: {0}, Layer: {1}, Parent: {2}, Serial:{3}", item.Name, item.Layer, item.RootParent, item.Serial );
							}

							from.FixedParticles( 0x376A, 9, 32, 5007, EffectLayer.Waist );
							from.PlaySound( 0x1E3 );
							m_Wire.Delete();
						}
						else
						{
							if ( Utility.RandomDouble() > 0.80 )
								from.SendMessage( "Zbran se nepodarilo vylepsit." );
							else
							{
								from.PlaySound( 0x307 );
								from.FixedParticles( 0x36BD, 20, 10, 5044, EffectLayer.Head );
								
								if ( m_Wire.Bonus > 1 )
								{
                           m_Wire.Bonus -= 1;
                           from.SendMessage( "Zbran se nepodarilo vylepsit a drat byl poskozen." );
                        }
                        else
                        {
                           m_Wire.Delete();
                           from.SendMessage( "Zbran se nepodarilo vylepsit a drat byl znicen." );
                        }
							}
						}
					}
				}
				else
					from.SendMessage( "Drat lze pouzit pouze na zbrane a evolution golema." );
			}
		}
	}

	public class MagicalWire : Item
	{
		public enum WireAttribute
		{
			LowerStatReq,
			//     		SelfRepair,
			HitLeechHits,
			HitLeechStam,
			HitLeechMana,
			HitLowerAttack,
			HitLowerDefend,
			HitMagicArrow,
			HitHarm,
			HitFireball,
			HitLightning,
			HitDispel,
			HitColdArea,
			HitFireArea,
			HitPoisonArea,
			HitEnergyArea,
			HitPhysicalArea,
			ResistPhysicalBonus,
			ResistFireBonus,
			ResistColdBonus,
			ResistPoisonBonus,
			ResistEnergyBonus,
			//     		UseBestSkill,
			//     		MageWeapon,
			DurabilityBonus,
			WeaponDamage,
			DefendChance,
			AttackChance,
			Luck,
			WeaponSpeed
		}
		
		private WireAttribute m_WireAttribute;
		private int m_Bonus;
		
		[CommandProperty(AccessLevel.GameMaster)]
		public WireAttribute WeaponWireAttribute
		{
			get { return m_WireAttribute; }
			set { m_WireAttribute = value; WireHue( this ); InvalidateProperties(); }
		}
		
		[CommandProperty(AccessLevel.GameMaster)]
		public int Bonus
		{
			get { return m_Bonus; }
			set
			{
				m_Bonus = value;
				if ( m_Bonus < 1 ) m_Bonus = 1;
				InvalidateProperties();
			}
		}
		
		[Constructable]
		public MagicalWire() : this ( RandomWireAttribute(), 1 )
		{
		}
		
		[Constructable]
		public MagicalWire( int bonus ) : this ( RandomWireAttribute(), bonus )
		{
		}
		
		[Constructable]
		public MagicalWire( WireAttribute attr, int bonus ) : base( 6263 )
		{
			Weight = 1.0;
			Hue = 1596;
			Name = "magical wire";
			LootType = LootType.Blessed;
			Stackable = false;
			WeaponWireAttribute = attr;
			Bonus = bonus;
		}
		
		private static WireAttribute RandomWireAttribute()
		{
			WireAttribute rnd = WireAttribute.LowerStatReq;
			
			switch ( Utility.Random( 27 ) )
			{
					case 0: rnd = WireAttribute.LowerStatReq; break;
					case 1: rnd = WireAttribute.HitLeechHits; break;
					case 2: rnd = WireAttribute.HitLeechStam; break;
					case 3: rnd = WireAttribute.HitLeechMana; break;
					case 4: rnd = WireAttribute.HitLowerAttack; break;
					case 5: rnd = WireAttribute.HitLowerDefend; break;
					case 6: rnd = WireAttribute.HitMagicArrow; break;
					case 7: rnd = WireAttribute.HitHarm; break;
					case 8: rnd = WireAttribute.HitFireball; break;
					case 9: rnd = WireAttribute.HitLightning; break;
					case 10: rnd = WireAttribute.HitDispel; break;
					case 11: rnd = WireAttribute.HitColdArea; break;
					case 12: rnd = WireAttribute.HitFireArea; break;
					case 13: rnd = WireAttribute.HitPoisonArea; break;
					case 14: rnd = WireAttribute.HitEnergyArea; break;
					case 15: rnd = WireAttribute.HitPhysicalArea; break;
					case 16: rnd = WireAttribute.ResistPhysicalBonus; break;
					case 17: rnd = WireAttribute.ResistFireBonus; break;
					case 18: rnd = WireAttribute.ResistColdBonus; break;
					case 19: rnd = WireAttribute.ResistPoisonBonus; break;
					case 20: rnd = WireAttribute.ResistEnergyBonus; break;
					case 21: rnd = WireAttribute.DurabilityBonus; break;
					case 22: rnd = WireAttribute.WeaponDamage; break;
					case 23: rnd = WireAttribute.DefendChance; break;
					case 24: rnd = WireAttribute.AttackChance; break;
					case 25: rnd = WireAttribute.Luck; break;
					case 26: rnd = WireAttribute.WeaponSpeed; break;
			}
			
			return rnd;
		}
		
		public void WireHue( MagicalWire wire )
		{
			switch ( wire.WeaponWireAttribute )
			{
					case WireAttribute.LowerStatReq: wire.Hue = 1477; break;
					case WireAttribute.HitLeechHits: wire.Hue = 1194; break;
					case WireAttribute.HitLeechStam: wire.Hue = 1099; break;
					case WireAttribute.HitLeechMana: wire.Hue = 1363; break;
					case WireAttribute.HitLowerAttack: wire.Hue = 1097; break;
					case WireAttribute.HitLowerDefend: wire.Hue = 1180; break;
					case WireAttribute.HitMagicArrow: wire.Hue = 1098; break;
					case WireAttribute.HitHarm: wire.Hue = 1182; break;
					case WireAttribute.HitFireball: wire.Hue = 1101; break;
					case WireAttribute.HitLightning: wire.Hue = 1100; break;
					case WireAttribute.HitDispel: wire.Hue = 1601; break;
					case WireAttribute.HitColdArea: wire.Hue = 1095; break;
					case WireAttribute.HitFireArea: wire.Hue = 1060; break;
					case WireAttribute.HitPoisonArea: wire.Hue = 1094; break;
					case WireAttribute.HitEnergyArea: wire.Hue = 2123; break;
					case WireAttribute.HitPhysicalArea: wire.Hue = 1093; break;
					case WireAttribute.ResistPhysicalBonus: wire.Hue = 2305; break;
					case WireAttribute.ResistFireBonus: wire.Hue = 1096; break;
					case WireAttribute.ResistColdBonus: wire.Hue = 1151; break;
					case WireAttribute.ResistPoisonBonus: wire.Hue = 565; break;
					case WireAttribute.ResistEnergyBonus: wire.Hue = 1361; break;
					case WireAttribute.DurabilityBonus: wire.Hue = 1179; break;
					case WireAttribute.WeaponDamage: wire.Hue = 1092; break;
					case WireAttribute.DefendChance: wire.Hue = 1192; break;
					case WireAttribute.AttackChance: wire.Hue = 1196; break;
					case WireAttribute.Luck: wire.Hue = 1150; break;
					case WireAttribute.WeaponSpeed: wire.Hue = 1195; break;
			}
		}
		
		public static double GetChance( Mobile from )
		{
			double chance = 0.05 + ((from.Skills[SkillName.Tinkering].Value - 75.0) / (190.0 - 75.0) * (1.0 - 0.05));
			
			/*if ( from.Skills[SkillName.Tinkering].Value > 74.9 && from.Talisman is BaseTalisman )
			{
				BaseTalisman talisman = (BaseTalisman) from.Talisman;
				
				if ( talisman.Skill == SkillName.Tinkering )
					chance += talisman.SuccessBonus / (double) 100;
			}*/
			
			chance += Math.Min( 0.05, ( (double) Guilds.Guild.GetLevel( from ) ) / 1000.0 );
			
			if ( chance < 0.0 ) chance = 0.0;
			else if ( chance > 1.0 ) chance = 1.0;
			
			return ( ( from.AccessLevel >= AccessLevel.GameMaster ) ? 1.0 : chance );
		}
		
      public override void GetContextMenuEntries( Mobile from, List<ContextMenuEntry> list )
      {
          base.GetContextMenuEntries( from, list );

          if ( this.BlessedFor == null && this.Bonus > 1 && this.IsChildOf( from.Backpack ) )
             list.Add( new DivideEntry( from, this ) );
      }

      public class DivideEntry : ContextMenuEntry
      {
          private Mobile m_From;
          private MagicalWire m_wire;

          public DivideEntry(Mobile from, MagicalWire wire) : base(6142, 1)//Disassemble
          {
              m_From = from;
              m_wire = wire;
          }

          public override void OnClick()
          {
              if ( m_wire == null || m_wire.Deleted )
               return;
              
              if ( !m_wire.IsChildOf( m_From.Backpack ) )
                  m_From.SendLocalizedMessage( 1042001 ); // That must be in your pack for you to use it.
              else if ( m_wire.Bonus > 1 )
              {
                  for ( int i = m_wire.Bonus; i > 0; --i )
                  {
                     m_From.AddToBackpack( new MagicalWire( m_wire.WeaponWireAttribute, 1 ) );
                  }
                  
                  m_wire.Delete();
              } 
          }
      }
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			if (m_WireAttribute == WireAttribute.ResistPhysicalBonus)
				list.Add(1072382, m_Bonus.ToString()); // physical resist +~1_val~%
			
			if (m_WireAttribute == WireAttribute.ResistFireBonus)
				list.Add(1072383, m_Bonus.ToString()); // fire resist +~1_val~%
			
			if (m_WireAttribute == WireAttribute.ResistColdBonus)
				list.Add(1072384, m_Bonus.ToString()); // cold resist +~1_val~%
			
			if (m_WireAttribute == WireAttribute.ResistPoisonBonus)
				list.Add(1072385, m_Bonus.ToString()); // poison resist +~1_val~%
			
			if (m_WireAttribute == WireAttribute.ResistEnergyBonus)
				list.Add(1072386, m_Bonus.ToString()); // energy resist +~1_val~%
			
			if (m_WireAttribute == WireAttribute.LowerStatReq)
				list.Add(1060435, m_Bonus.ToString()); // lower requirements ~1_val~%

			if (m_WireAttribute == WireAttribute.DurabilityBonus)
				list.Add(1060410, m_Bonus.ToString()); // durability ~1_val~%

			if (m_WireAttribute == WireAttribute.HitColdArea)
				list.Add(1060416, m_Bonus.ToString()); // hit cold area ~1_val~%

			if (m_WireAttribute == WireAttribute.HitDispel)
				list.Add(1060417, m_Bonus.ToString()); // hit dispel ~1_val~%

			if (m_WireAttribute == WireAttribute.HitEnergyArea)
				list.Add(1060418, m_Bonus.ToString()); // hit energy area ~1_val~%

			if (m_WireAttribute == WireAttribute.HitFireArea)
				list.Add(1060419, m_Bonus.ToString()); // hit fire area ~1_val~%

			if (m_WireAttribute == WireAttribute.HitFireball)
				list.Add(1060420, m_Bonus.ToString()); // hit fireball ~1_val~%

			if (m_WireAttribute == WireAttribute.HitHarm)
				list.Add(1060421, m_Bonus.ToString()); // hit harm ~1_val~%

			if (m_WireAttribute == WireAttribute.HitLeechHits)
				list.Add(1060422, m_Bonus.ToString()); // hit life leech ~1_val~%

			if (m_WireAttribute == WireAttribute.HitLightning)
				list.Add(1060423, m_Bonus.ToString()); // hit lightning ~1_val~%

			if (m_WireAttribute == WireAttribute.HitLowerAttack)
				list.Add(1060424, m_Bonus.ToString()); // hit lower attack ~1_val~%

			if (m_WireAttribute == WireAttribute.HitLowerDefend)
				list.Add(1060425, m_Bonus.ToString()); // hit lower defense ~1_val~%

			if (m_WireAttribute == WireAttribute.HitMagicArrow)
				list.Add(1060426, m_Bonus.ToString()); // hit magic arrow ~1_val~%

			if (m_WireAttribute == WireAttribute.HitLeechMana)
				list.Add(1060427, m_Bonus.ToString()); // hit mana leech ~1_val~%

			if (m_WireAttribute == WireAttribute.HitPhysicalArea)
				list.Add(1060428, m_Bonus.ToString()); // hit physical area ~1_val~%

			if (m_WireAttribute == WireAttribute.HitPoisonArea)
				list.Add(1060429, m_Bonus.ToString()); // hit poison area ~1_val~%

			if (m_WireAttribute == WireAttribute.HitLeechStam)
				list.Add(1060430, m_Bonus.ToString()); // hit stamina leech ~1_val~%


			if (m_WireAttribute == WireAttribute.WeaponDamage)
				list.Add(1060401, m_Bonus.ToString()); // damage increase ~1_val~%
			
			if (m_WireAttribute == WireAttribute.DefendChance)
				list.Add(1060408, m_Bonus.ToString()); // defense chance increase ~1_val~%
			
			if (m_WireAttribute == WireAttribute.AttackChance)
				list.Add(1060415, m_Bonus.ToString()); // hit chance increase ~1_val~%
			
			if (m_WireAttribute == WireAttribute.Luck)
				list.Add(1060436, m_Bonus.ToString()); // luck ~1_val~
			
			if (m_WireAttribute == WireAttribute.WeaponSpeed)
				list.Add(1060486, m_Bonus.ToString()); // swing speed increase ~1_val~%
		}

		public MagicalWire( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
			
			writer.Write(m_Bonus);
			writer.Write((int)m_WireAttribute);
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
			
			m_Bonus = reader.ReadInt();
			m_WireAttribute = (WireAttribute)reader.ReadInt();
		}

		public override bool DisplayLootType{ get{ return false; } }
		public override bool DisplayWeight { get { return false; } }
		
		public override void OnDoubleClick( Mobile from )
		{
			if ( !IsChildOf( from.Backpack ) ) // Make sure its in their pack
			{
				from.SendLocalizedMessage( 1060640 );
			}
			else
			{
				from.SendMessage( "Zamer zbran kterou chces vylepsit, golema, nebo jiny drat pro skombinovani" );
				from.SendMessage( 33, "POZOR! Zbran, kterou vylepsis budes moci pouzivat jen ty!" );
				from.SendMessage( 61, "Sance na vylepseni zbrane: {0:F1}%", GetChance( from ) * 100 );
				from.SendMessage( 61, "Sance na vylepseni golema: 100%" );
				from.Target = new MagicalWireTarget( this );
			}
		}
	}
}


