using System;
using Server.Network;
using Server.Prompts;
using Server.Items;
using Server.Targeting;

namespace Server.Items
{
	public class RemoveCurseTarget : Target // Create our targeting class (which we derive from the base target class)
	{
		private RemoveCurseDeed m_Deed;

		public RemoveCurseTarget( RemoveCurseDeed deed ) : base( 1, false, TargetFlags.None )
		{
			m_Deed = deed;
		}

		protected override void OnTarget( Mobile from, object target ) // Override the protected OnTarget() for our feature
		{
			Item item = (Item)target;
			
			if ( item.LootType == LootType.Cursed )
			{
				if( item.RootParent != from ) // Make sure its in their pack or they are wearing it
				{
					from.SendMessage( "Musis mit predmet u sebe" );
				}
				else
				{
					item.LootType = LootType.Regular;
					from.SendMessage( "Kletba byla z predmetu odstranena" );
				   from.FixedParticles( 0x3779, 10, 15, 5004, EffectLayer.Head );
				   from.PlaySound( 0x1E4 );

					m_Deed.Delete(); // Delete the deed
				}
			}
			else
			{
				from.SendMessage( "Tento predmet neni proklety" );
			}
		}
	}

	public class RemoveCurseDeed : Item // Create the item class which is derived from the base item class
	{
		[Constructable]
		public RemoveCurseDeed() : base( 0x14F0 )
		{
			Weight = 1.0;
			Hue = 36;				//change hue
			Name = "a remove curse deed";
			LootType = LootType.Blessed;
		}

		public RemoveCurseDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			LootType = LootType.Blessed;

			int version = reader.ReadInt();
		}

		public override bool DisplayLootType{ get{ return false; } }

		public override void OnDoubleClick( Mobile from ) // Override double click of the deed to call our target
		{
			if ( !IsChildOf( from.Backpack ) ) // Make sure its in their pack
			{
				from.SendLocalizedMessage( 1060640 ); // That must be in your pack for you to use it.
			}
			else
			{
				from.SendMessage( "Z jakeho predmetu chces sejmout kletbu?" );
				from.Target = new RemoveCurseTarget( this ); // Call our target
			}
		}
	}
}


