using System;
using Server.Network;
using Server.Prompts;
using Server.Items;
using Server.Targeting;
using Server.Gumps;
using Server.Engines.XmlSpawner2;
using System.Collections;
using System.Collections.Generic;

namespace Server.Items
{
	public class ResetLevelItemDeed : Item
	{
		[Constructable]
		public ResetLevelItemDeed() : base( 0x14F0 )
		{
			Weight = 1.0;
			Hue = 1180;
			Name = "a reset levelable item deed";
			LootType = LootType.Blessed;
		}

		public ResetLevelItemDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}

		public override bool DisplayLootType{ get{ return false; } }

		public override void OnDoubleClick( Mobile from )
		{
			if ( !IsChildOf( from.Backpack ) ) // Make sure its in their pack
			{
				from.SendLocalizedMessage( 1060640 );
			}
			else
			{
				from.SendMessage( "Vyber levelovaci predmet, u ktereho chces vynulovat pridane vlastnosti a vratit body" );
				from.SendMessage( "POZOR: Resetovanim budou ztraceny bonusove body ziskane prechodem na kazdy 10ty level!" );
				from.Target = new ResetLevelItemTarget( this );
			}
		}
		
    	private class ResetLevelItemTarget : Target
    	{
    		private Item m_Deed;
    
    		public ResetLevelItemTarget( Item deed ) : base( 1, false, TargetFlags.None )
    		{
    			m_Deed = deed;
    		}
    
    		protected override void OnTarget( Mobile from, object target )
    		{
            

            if ( target is Item && target is ILevelable )
    			{
               Item item = (Item)target;
               
               if( item.RootParent != from )
					    from.SendLocalizedMessage( 1060640 );//The item must be in your backpack to use it.
               else
                  from.SendGump( new ConfirmResetLevelItem( item, m_Deed ) );
    			}
    			else
    				from.SendMessage( "Svitek lze pouzit pouze na levelovaci predmety." );
    		}
    	}
		
		private class ConfirmResetLevelItem : BaseConfirmGump
		{
			public override int TitleNumber{ get{ return 1075083; } } // <center>Warning!</center>
			public override int LabelNumber{ get{ return 1074975; } } // Are you sure you wish to select this?
			
			private Item m_Item;
			private Item m_Deed;
			
			public ConfirmResetLevelItem( Item item, Item deed ) : base()
			{
				m_Item = item;
				m_Deed = deed;
			}
			
			private void CopySkillBonuses( AosSkillBonuses attrsOld, AosSkillBonuses attrsNew )
			{
				double bonus;
				SkillName check;
            
            for ( int i = 0; i < 5; ++i )
				{
					attrsOld.GetValues( i, out check, out bonus );
					attrsNew.SetValues( i, check, bonus );
				}
			}
			
			public override void Confirm( Mobile from )
			{		
			   if ( m_Item == null || m_Item.Deleted || m_Deed == null || m_Deed.Deleted )
				  return;
				
				if ( !(m_Item is ILevelable) )
				{
               from.SendMessage( "Svitek lze pouzit pouze na levelovaci predmety." );
               return;
            }
            
				if ( ((ILevelable)m_Item).Level < 2 )
				{
               from.SendMessage( "Svitek lze pouzit pouze na levelovaci predmety s levelem vetsim nez 1." );
               return;
            }
            
				if ( m_Item.Name != null && !( m_Item is LegendaryPickaxe || m_Item.Name == "Tricko sampiona" 
               || m_Item is PoisonProofApron || m_Item is VestmentOfHighPriest ) )
				{
               from.SendMessage( "Toto je specialni levelovaci predmet a nelze jej resetnout." );
               return;
            }
				
				if ( m_Item is BaseWeapon && ((BaseWeapon)m_Item).Quality == WeaponQuality.Exceptional )
				{
               from.SendMessage( "Exceptional zbrane nelze resetnout." );
               return;
            }
				
            Item newitem = (Item)Activator.CreateInstance( m_Item.GetType() );
            
				if ( newitem == null )
				{
               from.SendMessage( "Chyba pri resetu predmetu, kontaktuj GM! (ERROR 01)" );
               return;
            }
            
            newitem.Hue = m_Item.Hue;
            newitem.ItemID = m_Item.ItemID;
            newitem.Name = m_Item.Name;
            newitem.LootType = m_Item.LootType;
            newitem.Insured = m_Item.Insured;
            newitem.BlessedFor = m_Item.BlessedFor;
            
            ((ILevelable)newitem).Experience = ((ILevelable)m_Item).Experience;
            ((ILevelable)newitem).Level = ((ILevelable)m_Item).Level;
            ((ILevelable)newitem).Points = (int)((((ILevelable)newitem).Level - 1) * Server.LevelItems.PointsPerLevel);
            ((ILevelable)newitem).MaxLevel = ((ILevelable)m_Item).MaxLevel;
            
            //Attachments
            ArrayList list = XmlAttach.FindAttachments( m_Item );

            if(list != null)
            {
                foreach( XmlAttachment a in list )
                {
                    if(a != null && !a.Deleted)
                    {
                        XmlAttach.AttachTo( newitem, a );
//                         from.SendMessage("\t{0} : {1} : {2}", a.GetType().Name, a.Name,  a.OnIdentify(from));
                    }
                }
            }
            
            if ( newitem is BaseArmor )
            {
               ((BaseArmor)newitem).HitPoints = ((BaseArmor)m_Item).HitPoints;
               ((BaseArmor)newitem).MaxHitPoints = ((BaseArmor)m_Item).MaxHitPoints;
               CopySkillBonuses( ((BaseArmor)m_Item).SkillBonuses, ((BaseArmor)newitem).SkillBonuses );
            }
            else if ( newitem is BaseClothing )
            {
               ((BaseClothing)newitem).HitPoints = ((BaseClothing)m_Item).HitPoints;
               ((BaseClothing)newitem).MaxHitPoints = ((BaseClothing)m_Item).MaxHitPoints;
               CopySkillBonuses( ((BaseClothing)m_Item).SkillBonuses, ((BaseClothing)newitem).SkillBonuses );
            }
            else if ( newitem is BaseJewel )
            {
               CopySkillBonuses( ((BaseJewel)m_Item).SkillBonuses, ((BaseJewel)newitem).SkillBonuses );
            }
            else if ( newitem is BaseWeapon )
            {
               ((BaseWeapon)newitem).HitPoints = ((BaseWeapon)m_Item).HitPoints;
               ((BaseWeapon)newitem).MaxHitPoints = ((BaseWeapon)m_Item).MaxHitPoints;
               ((BaseWeapon)newitem).Slayer2 = ((BaseWeapon)m_Item).Slayer2;
               CopySkillBonuses( ((BaseWeapon)m_Item).SkillBonuses, ((BaseWeapon)newitem).SkillBonuses );
               
               if ( newitem is BaseRanged && ( m_Item is BaseRanged && ((BaseRanged)m_Item).Balanced ) )
               {
                  ((BaseRanged)newitem).Balanced = ((BaseRanged)m_Item).Balanced;
                  ((BaseWeapon)newitem).Attributes.WeaponDamage += 20;
               }
            }
            
            from.SendMessage( 33, "Vlastnosti predmetu byly vynulovany." );
            from.AddToBackpack( newitem );
            m_Item.Delete();
            m_Deed.Delete();
			}
		}
	}
}


