using System;
using Server.Network;
using Server.Prompts;
using Server.Items;
using Server.Targeting;

namespace Server.Items
{
    public class ScrollOfKo : Item
    {
        [Constructable]
        public ScrollOfKo() : this(1)
        {
        }

        [Constructable]
        public ScrollOfKo(int amount) : base(7997)
        {
            Weight = 0.1;
            Hue = 1097;
            Stackable = true;
            Name = "scroll of ko";
            LootType = LootType.Regular;
            Amount = amount;
        }

        public ScrollOfKo(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
        }

        public override bool DisplayLootType { get { return false; } }

        public override void OnDoubleClick(Mobile from)
        {
            if (!IsChildOf(from.Backpack)) // Make sure its in their pack
            {
                from.SendLocalizedMessage(1060640);
            }
            else
            {
                from.SendMessage("Jakou cast bushido brneni, Zanbato zbran nebo Crusader's set chces vylepsit?");
                from.Target = new ScrollOfKoTarget(this);
            }
        }

        private class ScrollOfKoTarget : Target
        {
            private ScrollOfKo m_Deed;

            public ScrollOfKoTarget(ScrollOfKo deed) : base(1, false, TargetFlags.None)
            {
                m_Deed = deed;
            }

            protected override void OnTarget(Mobile from, object target)
            {
                if (target is CrusadersShield || target is CrusadersWarMace ||
                    target is KabutoOfChi || target is ArmsOfMakoto || target is LegsOfYuki || target is PlateOfMeiyo || target is Zanbato)
                {
                    Item brnko = (Item)target;

                    if (!brnko.IsChildOf(from.Backpack) || !m_Deed.IsChildOf(from.Backpack))
                        from.SendMessage("Musis mit svitek i vylepsovany predmet v batohu");
                    else if (brnko.BlessedFor != null && brnko.BlessedFor != from)
                        from.SendMessage("Toto neni tvuj predmet");
                    else
                    {
                        bool success = false;

                        if (brnko is CrusadersShield && ((CrusadersShield)brnko).UpgradeKoTier())
                            success = true;
                        else if (brnko is CrusadersWarMace && ((CrusadersWarMace)brnko).UpgradeKoTier())
                            success = true;
                        else if (brnko is KabutoOfChi && ((KabutoOfChi)brnko).UpgradeTier())
                            success = true;
                        else if (brnko is ArmsOfMakoto && ((ArmsOfMakoto)brnko).UpgradeTier())
                            success = true;
                        else if (brnko is LegsOfYuki && ((LegsOfYuki)brnko).UpgradeTier())
                            success = true;
                        else if (brnko is PlateOfMeiyo && ((PlateOfMeiyo)brnko).UpgradeTier())
                            success = true;
                        else if (brnko is Zanbato && ((Zanbato)brnko).UpgradeTier())
                            success = true;

                        if (!success)
                        {
                            if (brnko is CrusadersWarMace || brnko is CrusadersShield)
                                from.SendMessage("Predmet dosahl maximalni urovne, nebo neni aktivovan");
                            else
                                from.SendMessage("Predmet dosahl maximalni urovne");

                            if (brnko is Zanbato)
                                from.SendMessage("Zanbato musi mit uroven < 10, spending points 0, level 150");

                            return;
                        }

                        brnko.BlessedFor = from;
                        from.FixedParticles(14170, 1, 10, 0x1F78, m_Deed.Hue, 5, EffectLayer.Waist);
                        from.PlaySound(487);
                        from.PlaySound(480);
                        from.SendMessage("Uroven predmetu byla navysena");
                        m_Deed.Consume();
                    }
                }
                else
                {
                    from.SendMessage("Scroll lze pouzit pouze na Bushido armor, Zanbato zbran nebo Crusader's set!");
                    return;
                }

            }
        }
    }
}


