using System;

namespace Server.Items
{
	public class ScrollOfSuccess : Item
	{
		[Constructable]
		public ScrollOfSuccess() : this( 1 )
		{
		}

		[Constructable]
		public ScrollOfSuccess( int amount ) : base( 8012 )
		{
			Name = "scroll of success";
         Weight = 1.0;
			Stackable = true;
			Amount = amount;
			Hue = 618;
		}

		public ScrollOfSuccess( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}