using System;
using Server.Network;
using Server.Prompts;
using Server.Items;
using Server.Targeting;

namespace Server.Items
{
	public class ScrollOfVirtue : Item
	{
		[Constructable]
		public ScrollOfVirtue() : this( 1 )
		{
		}
      
      [Constructable]
		public ScrollOfVirtue( int amount ) : base( 7997 )
		{
			Weight = 0.1;
			Hue = 2642;
			Stackable = true;
			Name = "scroll of virtue";
			LootType = LootType.Blessed;
			Amount = amount;
		}

		public ScrollOfVirtue( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}

		public override bool DisplayLootType{ get{ return false; } }

		public override void OnDoubleClick( Mobile from )
		{
			if ( !IsChildOf( from.Backpack ) ) // Make sure its in their pack
			{
				from.SendLocalizedMessage( 1060640 );
			}
			else
			{
				from.SendMessage( "Jakou cast virtues brneni chces vylepsit?" );
				from.Target = new ScrollOfVirtueTarget( this );
			}
		}
		
		private class ScrollOfVirtueTarget : Target
		{
			private ScrollOfVirtue m_Deed;

			public ScrollOfVirtueTarget( ScrollOfVirtue deed ) : base( 1, false, TargetFlags.None )
			{
				m_Deed = deed;
			}

			protected override void OnTarget( Mobile from, object target )
			{
				if ( target is ArmsOfCompassion || target is CloakOfHumility || target is DupresShield || target is GauntletsOfValor || 
            target is GorgetOfTruth || target is HelmOfSpirituality || target is LegsOfHonor || target is PlateOfJustice || target is SolaretsOfSacrifice ||
            target is KnightsRing || target is CrusadersShield || target is CrusadersWarMace )
				{
    				Item brnko = (Item) target;
    					
    				if( !brnko.IsChildOf( from.Backpack ) || !m_Deed.IsChildOf( from.Backpack ) )
    					from.SendMessage( "Musis mit svitek i brneni v batohu" );
               else if( brnko.BlessedFor != null && brnko.BlessedFor != from )
    					from.SendMessage( "Toto neni tvoje brneni" );
    				else
    				{
    					bool success = false;
    					
    					if ( brnko is ArmsOfCompassion && ((ArmsOfCompassion)brnko).UpgradeTier() )
    					   success = true;
    					else if ( brnko is CloakOfHumility && ((CloakOfHumility)brnko).UpgradeTier() ) 
    					   success = true;
    					else if ( brnko is DupresShield && ((DupresShield)brnko).UpgradeTier() ) 
    					   success = true;
    					else if ( brnko is GauntletsOfValor && ((GauntletsOfValor)brnko).UpgradeTier() ) 
    					   success = true;
    					else if ( brnko is GorgetOfTruth && ((GorgetOfTruth)brnko).UpgradeTier() ) 
    					   success = true;
    					else if ( brnko is HelmOfSpirituality && ((HelmOfSpirituality)brnko).UpgradeTier() ) 
    					   success = true;
    					else if ( brnko is LegsOfHonor && ((LegsOfHonor)brnko).UpgradeTier() ) 
    					   success = true;
    					else if ( brnko is PlateOfJustice && ((PlateOfJustice)brnko).UpgradeTier() ) 
    					   success = true;
    					else if ( brnko is SolaretsOfSacrifice && ((SolaretsOfSacrifice)brnko).UpgradeTier() ) 
    					   success = true;
    					else if ( brnko is KnightsRing && ((KnightsRing)brnko).UpgradeTier() ) 
    					   success = true;
    					else if ( brnko is CrusadersShield && ((CrusadersShield)brnko).UpgradeTier() ) 
    					   success = true;
    					else if ( brnko is CrusadersWarMace && ((CrusadersWarMace)brnko).UpgradeTier() ) 
    					   success = true;
    					   
    					if ( !success )
    					{
                     from.SendMessage( "Maximalni uroven {0}", ( brnko is KnightsRing || brnko is CrusadersShield || brnko is CrusadersWarMace ) ? "je 10" : ( brnko is DupresShield ) ? "stitu je 6" : "brneni je 5" );
                     return;
                  }                  
    					   
                  brnko.BlessedFor = from;
                  from.FixedParticles( 14170, 1, 10, 0x1F78, m_Deed.Hue, 5, EffectLayer.Waist );
    					from.PlaySound( 487 );
    					from.PlaySound( 480 );
    					from.SendMessage( "Uroven byla navysena" );
    					m_Deed.Consume();
    				}
            }
				else
				{
					from.SendMessage( "Scroll lze pouzit pouze na virtues nebo crusaders set!" );
					return;
				}		

			}
		}
	}
}


