using System;
using Server.Network;
using Server.Prompts;
using Server.Items;
using Server.Targeting;

namespace Server.Items
{
	public class SelfRepairOilTarget : Target
	{
		private SelfRepairOil m_Oil;

		public SelfRepairOilTarget( SelfRepairOil oil ) : base( 1, false, TargetFlags.None )
		{
			m_Oil = oil;
		}

		protected override void OnTarget( Mobile from, object target )
		{
			if ( target is ILevelable )
            from.SendMessage( "Olej nelze pouzit na levelovaci predmety!" );
         else if ( target is BaseArmor )
			{
				BaseArmor item = (BaseArmor)target;
				
            if( item.RootParent != from )
					from.SendMessage( "Musis mit predmet u sebe" );
            else if( item.MaxHitPoints < 1 )
					from.SendMessage( "Toto brneni je neposkoditelne a proto nepotrebuje self repair vlastnost" );
            else if( item.ArmorAttributes.SelfRepair > 9 )
					from.SendMessage( "Toto brneni jiz ma vlastnost self repair na maximalni vysi!" );
				else
				{
					item.ArmorAttributes.SelfRepair += 1;
					from.SendMessage( "Vlastnost Self repair byla uspesne pridana." );
					m_Oil.Delete();
				}
			}
         else if ( target is BaseClothing )
			{
				BaseClothing item = (BaseClothing)target;
				
            if( item.RootParent != from )
					from.SendMessage( "Musis mit predmet u sebe" );
            else if( item.MaxHitPoints < 1 )
					from.SendMessage( "Toto obleceni je neposkoditelne a proto nepotrebuje self repair vlastnost" );
            else if( item.ClothingAttributes.SelfRepair > 9 )
					from.SendMessage( "Toto obleceni jiz ma vlastnost self repair na maximalni vysi!" );
				else
				{
					item.ClothingAttributes.SelfRepair += 1;
					from.SendMessage( "Vlastnost Self repair byla uspesne pridana." );
					m_Oil.Delete();
				}
			}
         else if ( target is BaseWeapon )
			{
				BaseWeapon item = (BaseWeapon)target;
				
            if( item.RootParent != from )
					from.SendMessage( "Musis mit predmet u sebe" );
            else if( item.MaxHitPoints < 1 )
					from.SendMessage( "Tato zbran je neposkoditelna a proto nepotrebuje self repair vlastnost" );
            else if( item.WeaponAttributes.SelfRepair > 9 )
					from.SendMessage( "Tato zbran jiz ma vlastnost self repair na maximalni vysi!" );
				else
				{
					item.WeaponAttributes.SelfRepair += 1;
					from.SendMessage( "Vlastnost Self repair byla uspesne pridana." );
					m_Oil.Delete();
				}
			}
			else
				from.SendMessage( "Olej lze pouzit pouze na nelevelovaci brneni, obleceni a zbrane." );
		}
	}

	public class SelfRepairOil : Item
	{
		[Constructable]
		public SelfRepairOil() : base( 7192 )
		{
			Weight = 1.0;
			Hue = 1931;
			Name = "a magical oil of self repair";
			LootType = LootType.Blessed;
		}

		public SelfRepairOil( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			LootType = LootType.Blessed;

			int version = reader.ReadInt();
		}

		public override bool DisplayLootType{ get{ return false; } }

		public override void OnDoubleClick( Mobile from )
		{
			if ( !IsChildOf( from.Backpack ) ) // Make sure its in their pack
			{
				from.SendLocalizedMessage( 1060640 );
			}
			else
			{
				from.SendMessage( "Do jakeho brneni nebo zbrane chces pridat +1 self repair?" );
				from.Target = new SelfRepairOilTarget( this );
			}
		}
	}
}


