using System;
using Server.Network;
using Server.Prompts;
using Server.Items;
using Server.Targeting;
using Server.Gumps;

namespace Server.Items
{
	public class SlayerScroll : Item
	{
		[Constructable]
		public SlayerScroll() : base( 5358 )
		{
			Weight = 1.0;
			Hue = 311;
			Name = "weapon slayer scroll";
			LootType = LootType.Blessed;
		}

		public SlayerScroll( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			LootType = LootType.Blessed;

			int version = reader.ReadInt();
		}

		public override bool DisplayLootType{ get{ return false; } }

		public override void OnDoubleClick( Mobile from )
		{
			if ( !IsChildOf( from.Backpack ) ) // Make sure its in their pack
			{
				from.SendLocalizedMessage( 1060640 );
			}
			else
			{
				from.SendMessage( "Do jake zbrane nebo magicke knihy chces pridat slayer vlastnost?" );
				from.SendMessage( 33, "POZOR! Predmět, ktery vylepsis budes moci pouzivat jen ty!" );
				from.Target = new SlayerTarget( this );
			}
		}
		
    	private class SlayerTarget : Target
    	{
    		private SlayerScroll m_Scroll;
    
    		public SlayerTarget( SlayerScroll scroll ) : base( 1, false, TargetFlags.None )
    		{
    			m_Scroll = scroll;
    		}
    
    		protected override void OnTarget( Mobile from, object target )
    		{
    			if ( target is BaseWeapon )
    			{
    				BaseWeapon weap = (BaseWeapon)target;
    				
    				if( !weap.IsChildOf( from.Backpack ) )
    					from.SendLocalizedMessage( 1060640 );//The item must be in your backpack to use it.
               else if( weap.BlessedFor != null && weap.BlessedFor != from )
					 from.SendMessage( "Toto neni tvuj predmet" );
               else if( weap is HolySword || weap is CrusadersWarMace )
					 from.SendMessage( "Na tuto zbran nelze svitek pouzit" );
    				else
    				{
//                   if ( weap.Slayer2 == SlayerName.None )
                     from.SendGump( new SlayerGump( weap, m_Scroll ) );
//                   else
//                      from.SendMessage( "Tato zbran jiz slayer vlastnost obsahuje" );
               }
    			}
    			else if ( target is Spellbook )
    			{
    				Spellbook book = (Spellbook)target;
    				
    				if( book.RootParent != from )
    					from.SendLocalizedMessage( 1060640 );//The item must be in your backpack to use it.
               else if( book.BlessedFor != null && book.BlessedFor != from )
					 from.SendMessage( "Toto neni tvuj predmet" );
    				else
    				{
//                   if ( book.Slayer2 == SlayerName.None )
                     from.SendGump( new SlayerGump( book, m_Scroll ) );
//                   else
//                      from.SendMessage( "Tato kniha jiz slayer vlastnost obsahuje" );
               }
    			}
    			else
    				from.SendMessage( "Svitek lze pouzit pouze na zbrane a magicke knihy." );
    		}
    	}
		
		private class SlayerGump : Gump
		{

			private Item m_Scroll;
			private Item m_Weapon;
			
			public SlayerGump( Item weapon, Item scroll ) : base( 70, 70 )
			{
				m_Weapon = weapon;
				m_Scroll = scroll;
				
				this.Closable=true;
				this.Disposable=true;
				this.Dragable=true;
				this.Resizable=false;

				AddPage(0);
				AddBackground(0, 0, 347, 297, 9200);
				AddItem(16, 30, 8415);
				AddRadio(58, 38, 210, 211, false, (int)Buttons.Repond);
				AddLabel(89, 37, 0, @"Repond");
				AddItem(16, 83, 8423);
				AddRadio(58, 92, 210, 211, false, (int)Buttons.Undead);
				AddLabel(89, 92, 0, @"Undead");
				AddItem(16, 137, 8407);
				AddRadio(58, 145, 210, 211, false, (int)Buttons.Elemental);
				AddLabel(89, 144, 0, @"Elemental");
				AddItem(9, 192, 9606);
				AddRadio(58, 202, 210, 211, false, (int)Buttons.Demon);
				AddLabel(89, 201, 0, @"Demon");
				
				AddRadio(18, 252, 210, 211, false, (int)Buttons.RemoveSlayer);
				AddLabel(49, 251, 0, @"Odebrat obe vlastnosti slayer");
				
				AddItem(183, 30, 8406);
				AddRadio(233, 38, 210, 211, false, (int)Buttons.Reptile);
				AddLabel(268, 37, 0, @"Reptile");
				AddItem(144, 81, 8445);
				AddRadio(233, 92, 210, 211, false, (int)Buttons.Arachnid);
				AddLabel(268, 91, 0, @"Arachnid");
				AddItem(185, 136, 9654);
				AddRadio(233, 145, 210, 211, false, (int)Buttons.Fey);
				AddLabel(268, 144, 0, @"Fey");
				AddButton(255, 199, 247, 248, (int)Buttons.Send, GumpButtonType.Reply, 0);
				AddLabel(117, 4, 32, @"Vyber typ slayeru");
			}

			public enum Buttons
			{
				Repond,
				Undead,
				Elemental,
				Demon,
				Reptile,
				Arachnid,
				Fey,
				Send,
				RemoveSlayer
			}

			public override void OnResponse(NetState sender, RelayInfo info)
			{
				Mobile from = sender.Mobile;
				
				if ( m_Weapon == null || m_Weapon.Deleted || m_Scroll == null || m_Scroll.Deleted )
					return;
				if ( !(m_Weapon is BaseWeapon) && !(m_Weapon is Spellbook) )
					return;
					
				bool added = false;
				
				switch( info.ButtonID )
				{
					case (int)Buttons.Send:
						{
							if (info.IsSwitched( (int)Buttons.Repond) )
							{
								if( info.Switches.Length == 1 )
								{
									if ( m_Weapon is BaseWeapon )
                              ((BaseWeapon)m_Weapon).Slayer2 = SlayerName.Repond;
                           else if ( m_Weapon is Spellbook )
                              ((Spellbook)m_Weapon).Slayer2 = SlayerName.Repond;

									added = true;
                        }
							}
							else if (info.IsSwitched( (int)Buttons.Undead) )
							{
								if( info.Switches.Length == 1 )
								{
									if ( m_Weapon is BaseWeapon )
                              ((BaseWeapon)m_Weapon).Slayer2 = SlayerName.Silver;
                           else if ( m_Weapon is Spellbook )
                              ((Spellbook)m_Weapon).Slayer2 = SlayerName.Silver;

									added = true;
                        }
							}
							else if (info.IsSwitched( (int)Buttons.Elemental) )
							{
								if( info.Switches.Length == 1 )
								{
									if ( m_Weapon is BaseWeapon )
                              ((BaseWeapon)m_Weapon).Slayer2 = SlayerName.ElementalBan;
                           else if ( m_Weapon is Spellbook )
                              ((Spellbook)m_Weapon).Slayer2 = SlayerName.ElementalBan;

									added = true;
                        }
							}
							else if (info.IsSwitched( (int)Buttons.Demon) )
							{
								if( info.Switches.Length == 1 )
								{
									if ( m_Weapon is BaseWeapon )
                              ((BaseWeapon)m_Weapon).Slayer2 = SlayerName.Exorcism;
                           else if ( m_Weapon is Spellbook )
                              ((Spellbook)m_Weapon).Slayer2 = SlayerName.Exorcism;

									added = true;
                        }
							}
							else if (info.IsSwitched( (int)Buttons.Reptile) )
							{
								if( info.Switches.Length == 1 )
								{
									if ( m_Weapon is BaseWeapon )
                              ((BaseWeapon)m_Weapon).Slayer2 = SlayerName.ReptilianDeath;
                           else if ( m_Weapon is Spellbook )
                              ((Spellbook)m_Weapon).Slayer2 = SlayerName.ReptilianDeath;

									added = true;
                        }
							}
							else if (info.IsSwitched( (int)Buttons.Arachnid) )
							{
								if( info.Switches.Length == 1 )
								{
									if ( m_Weapon is BaseWeapon )
                              ((BaseWeapon)m_Weapon).Slayer2 = SlayerName.ArachnidDoom;
                           else if ( m_Weapon is Spellbook )
                              ((Spellbook)m_Weapon).Slayer2 = SlayerName.ArachnidDoom;

									added = true;
                        }
							}
							else if (info.IsSwitched( (int)Buttons.Fey) )
							{
								if( info.Switches.Length == 1 )
								{
									if ( m_Weapon is BaseWeapon )
                              ((BaseWeapon)m_Weapon).Slayer2 = SlayerName.Fey;
                           else if ( m_Weapon is Spellbook )
                              ((Spellbook)m_Weapon).Slayer2 = SlayerName.Fey;

									added = true;
                        }
							}
							else if (info.IsSwitched( (int)Buttons.RemoveSlayer) )
							{
								if( info.Switches.Length == 1 )
								{
									if ( m_Weapon is BaseWeapon )
									{
                              ((BaseWeapon)m_Weapon).Slayer = SlayerName.None;
                              ((BaseWeapon)m_Weapon).Slayer2 = SlayerName.None;
                           }
                           else if ( m_Weapon is Spellbook )
                           {
                              ((Spellbook)m_Weapon).Slayer = SlayerName.None;
                              ((Spellbook)m_Weapon).Slayer2 = SlayerName.None;
                           }

									added = true;
                        }
							}
						}
						break;
				}
				
				if ( added )
				{
      			from.FixedParticles( 0x376A, 9, 32, 5007, EffectLayer.Waist );
      			from.PlaySound( 487 );
               m_Scroll.Delete();
               m_Weapon.BlessedFor = from;
               from.SendMessage( "Zmena probehla uspesne" );               
            }
			}
		}
	}
}


