using System;
using Server.Network;
using Server.Prompts;
using Server.Items;
using Server.Targeting;

namespace Server.Items
{
	public class SpendingPointTarget : Target // Create our targeting class (which we derive from the base target class)
	{
		private SpendingPointsScroll m_Scroll;

		public SpendingPointTarget( SpendingPointsScroll scroll ) : base( 1, false, TargetFlags.None )
		{
			m_Scroll = scroll;
		}

		protected override void OnTarget( Mobile from, object target )
		{
			if ( target is Item && target is ILevelable )
			{
				Item item = (Item)target;
				
				if( item.RootParent != from )
					from.SendLocalizedMessage( 1060640 );//The item must be in your backpack to use it.
            else if( item.BlessedFor != null && item.BlessedFor != from )
					from.SendMessage( "Toto neni tvuj predmet" );
				else if ( ((ILevelable)item).Level < 2 )
					from.SendMessage( "Svitek lze pouzit pouze na levelovaci predmety s levelem vetsim nez 1." );
				else
				{
					int amount = ( CraftLog.LastWinner == from ) ? m_Scroll.Amount * 2 : m_Scroll.Amount;
               
               item.BlessedFor = from;
					((ILevelable)item).Points += amount;
					item.InvalidateProperties();
					from.SendMessage( "Predmetu bylo pridano {0} spending points.", amount );
					from.FixedParticles( 0x375A, 10, 15, 5011, EffectLayer.Head );
					from.PlaySound( 0x1EB );

					m_Scroll.Delete(); // Delete the Scroll
				}
			}
			else
				from.SendMessage( "Svitek lze pouzit pouze na levelovaci predmety." );
		}
	}

	public class SpendingPointsScroll : Item // Create the item class which is derived from the base item class
	{
		[Constructable]
		public SpendingPointsScroll() : base( 7997 )
		{
			Weight = 0.1;
			Hue = 100;				//change hue
			Name = "spending point scroll";
			LootType = LootType.Regular;
			Stackable = true;
		}
		
		public override void GetProperties( ObjectPropertyList list )
		{
			base.GetProperties( list );
			list.Add( "Levelable Items Only" );
		}

		public SpendingPointsScroll( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}

		public override bool DisplayLootType{ get{ return false; } }

		public override void OnDoubleClick( Mobile from ) // Override double click of the Scroll to call our target
		{
			if ( !IsChildOf( from.Backpack ) ) // Make sure its in their pack
			{
				from.SendLocalizedMessage( 1060640 ); // That must be in your pack for you to use it.
			}
			else
			{
				from.SendMessage( "Do jakeho levelovaciho predmetu chces pridat spending point?" );
				from.SendMessage( 33, "POZOR! {0}predmet budes moci pouzivat jen ty!", ( this.Amount > 1 ) ? "Pouzije se cela hromadka scrollu a " : "" );
				from.SendMessage( 33, "Resetnutim predmetu budou body pridane svitkem ztraceny!" );
				from.Target = new SpendingPointTarget( this ); // Call our target
			}
		}
	}
}


