using System;
using Server.Network;
using Server.Prompts;
using Server.Items;
using Server.Targeting;

namespace Server.Items
{
	public class UnblessForTarget : Target // Create our targeting class (which we derive from the base target class)
	{
		private UnblessForDeed m_Deed;

		public UnblessForTarget( UnblessForDeed deed ) : base( 1, false, TargetFlags.None )
		{
			m_Deed = deed;
		}

		protected override void OnTarget( Mobile from, object target )
		{
         if ( !( target is Item ) )
         {
			   from.SendMessage( "Svitek lze pouzit pouze na predmety!" );
			   return;
         }
         
			Item item = (Item)target;
			
			if ( item == null || target is KnightsRing || target is ILevelable )
			   from.SendMessage( "Svitek nelze pouzit na tento predmet!" );
         else if ( item.BlessedFor != null )
			{
				if( item.RootParent != from ) // Make sure its in their pack or they are wearing it
				{
					from.SendMessage( "Musis mit predmet u sebe" );
				}
				else
				{
					item.BlessedFor = null;
					from.SendMessage( "Pouto mezi majitelem a predmetem bylo preruseno." );
					from.FixedParticles( 0x375A, 10, 15, 5011, EffectLayer.Head );
				   from.PlaySound( 0x1EB );

					m_Deed.Delete(); // Delete the deed
				}
			}
			else
			{
				from.SendMessage( "Tento predmet neni k nikomu pripoutany" );
			}
		}
	}

	public class UnblessForDeed : Item // Create the item class which is derived from the base item class
	{
		[Constructable]
		public UnblessForDeed() : base( 0x14F0 )
		{
			Weight = 1.0;
			Hue = 1947;				//change hue
			Name = "svitek na zruseni pouta mezi predmetem a majitelem";
			LootType = LootType.Blessed;
		}

		public UnblessForDeed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}

		public override bool DisplayLootType{ get{ return false; } }

		public override void OnDoubleClick( Mobile from ) // Override double click of the deed to call our target
		{
			if ( !IsChildOf( from.Backpack ) ) // Make sure its in their pack
			{
				from.SendLocalizedMessage( 1060640 ); // That must be in your pack for you to use it.
			}
			else
			{
				from.SendMessage( "Z jakeho predmetu chces odebrat jeho pouto k majiteli?" );
				from.Target = new UnblessForTarget( this ); // Call our target
			}
		}
	}
}


