using System;
using Server.Network;
using Server.Prompts;
using Server.Items;
using Server.Targeting;

namespace Server.Items
{
	public class UnholyRune : Item
	{
		[Constructable]
		public UnholyRune() : this( 1 )
		{
		}
      
      [Constructable]
		public UnholyRune( int amount ) : base( 5154 )
		{
			Weight = 1.0;
			Hue = 2546;
			Stackable = true;
			Name = "unholy rune";
			LootType = LootType.Blessed;
			Amount = amount;
		}

		public UnholyRune( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}

		public override bool DisplayLootType{ get{ return false; } }

		public override void OnDoubleClick( Mobile from )
		{
			if ( !IsChildOf( from.Backpack ) ) // Make sure its in their pack
			{
				from.SendLocalizedMessage( 1060640 );
			}
			else
			{
				from.SendMessage( "Jakou deamon bone helmet chces vylepsit?" );
				from.SendMessage( "POZOR! Vylepsenou helmu budes moci pouzivat jen ty!" );
				from.Target = new UnholyRuneTarget( this );
			}
		}
		
		private class UnholyRuneTarget : Target
		{
			private UnholyRune m_Deed;

			public UnholyRuneTarget( UnholyRune deed ) : base( 1, false, TargetFlags.None )
			{
				m_Deed = deed;
			}

			protected override void OnTarget( Mobile from, object target )
			{
				if ( !( target is DaemonHelm ) )
				{
					from.SendMessage( "Runu lze pouzit pouze na Daemon Bone Helmet!" );
					return;
				}
				
				DaemonHelm helm = (DaemonHelm) target;
					
				if ( helm == null || helm.Bonus >= 10 )
					from.SendMessage( "Maximalni uroven helmy je 10!" );
				else if( !helm.IsChildOf( from.Backpack ) || !m_Deed.IsChildOf( from.Backpack ) )
					from.SendMessage( "Musis mit runu i helmu v batohu" );
            else if( helm.BlessedFor != null && helm.BlessedFor != from )
					from.SendMessage( "Toto neni tvoje helma" );
				else
				{
					helm.Bonus++;
					helm.BlessedFor = from;
               from.FixedParticles( 14170, 1, 10, 0x1F78, m_Deed.Hue, 5, EffectLayer.Waist );
					from.PlaySound( 521 );
					from.PlaySound( 412 );
					from.SendMessage( "Uroven helmy byla navysena na {0}", helm.Bonus );
					m_Deed.Consume();
				}
			}
		}
	}
}


