using System;
using Server;
using Server.Network;
using Server.Regions;
using Server.Multis;
using Server.Gumps;
using Server.Targeting;

namespace Server.Items
{
	public class CarpetColor : Item, IDyable
	{
		[Constructable]
		public CarpetColor() : base( 7862 )
		{
			Weight = 6;
			Movable = true;
			Name = "Barva na koberce";
		}
		
		public override void OnDoubleClick( Mobile from )
		{
			if ( !CheckUse( this, from ) )
				return;
			
			if ( this.Hue == 0 )
				from.SendMessage( "Jaky koberec chces odbarvit?" );
			else
				from.SendMessage( "Jaky koberec chces obarvit?" );
			
			from.Target = new InternalTarget( this );
		}
		
		public static bool InHouse( Mobile from )
		{
			BaseHouse house = BaseHouse.FindHouseAt( from );

			return ( house != null && house.IsCoOwner( from ) );
		}

		public static bool CheckUse( CarpetColor tool, Mobile from )
		{
			if ( tool.Deleted || !tool.IsChildOf( from.Backpack ) )
				from.SendLocalizedMessage( 1042001 ); // That must be in your pack for you to use it.
			else if ( !InHouse( from ) )
				from.SendLocalizedMessage( 502092 ); // You must be in your house to do this.
			else
				return true;

			return false;
		}
		
		public CarpetColor(Serial serial) : base(serial)
		{
		}

		public bool Dye( Mobile from, DyeTub sender )
		{
			if ( Deleted )
				return false;

			Hue = sender.DyedHue;

			return true;
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();
		}
		
		//Target class

		public class InternalTarget : Target
		{
			private CarpetColor m_Color;
			
			public InternalTarget( CarpetColor color ) : base( 2, false, TargetFlags.None )
			{
				m_Color = color;
			}
			
			protected override void OnTarget( Mobile from, object targeted )
			{
				if ( targeted is AddonComponent )
				{
					AddonComponent component = (AddonComponent) targeted;
					
					if ( component.Addon is VariableCarpetAddon )
					{
						VariableCarpetAddon carpet = (VariableCarpetAddon) component.Addon;
						
						BaseHouse house = BaseHouse.FindHouseAt( carpet );
						
						if ( house != null && house.IsCoOwner( from ) )
						{
							if ( carpet.Hue == 0 && m_Color.Hue == 0 )
							{
								from.SendMessage( "Nemuzes odbarvit neobarveny koberec!" );
							}
							else
							{
								carpet.Hue = m_Color.Hue;
								m_Color.Delete();
							}
						}
						else
							from.SendLocalizedMessage( 502092 ); // You must be in your house to do this.
					}
					else
						from.SendMessage( "Touto barvou lze obarvit pouze koberec." );
				}
				else
					from.SendMessage( "Touto barvou lze obarvovat pouze koberce." );
			}
		}
	}
}
