using System;
using Server.Network;
using Server.Prompts;
using Server.Items;
using Server.Targeting;
using Server.Gumps;

namespace Server.Items
{
	public class WeaponAbilityScroll : Item
	{
		[Constructable]
		public WeaponAbilityScroll() : this( 1 )
		{
		}

		[Constructable]
		public WeaponAbilityScroll( int amount ) : base( 7997 )
		{
			Name = "weapon ability change scroll";
         Weight = 1.0;
			Stackable = true;
			Amount = amount;
			Hue = 1099;
			LootType = LootType.Blessed;
		}

		public WeaponAbilityScroll( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			LootType = LootType.Blessed;

			int version = reader.ReadInt();
		}

		public override bool DisplayLootType{ get{ return false; } }

		public override void OnDoubleClick( Mobile from )
		{
			if ( !IsChildOf( from.Backpack ) ) // Make sure its in their pack
			{
				from.SendLocalizedMessage( 1060640 );
			}
			else
			{
				from.SendMessage( "U jake zbrane chces zmenit abilitu?" );
				from.SendMessage( 33, "POZOR! Predmět, ktery vylepsis budes moci pouzivat jen ty!" );
				from.Target = new InternalTarget( this );
			}
		}
		
    	private class InternalTarget : Target
    	{
    		private WeaponAbilityScroll m_Scroll;
    
    		public InternalTarget( WeaponAbilityScroll scroll ) : base( 1, false, TargetFlags.None )
    		{
    			m_Scroll = scroll;
    		}
    
    		protected override void OnTarget( Mobile from, object target )
    		{
    			if ( target is BaseWeapon )
    			{
    				BaseWeapon weap = (BaseWeapon)target;
    				
    				if( !weap.IsChildOf( from.Backpack ) )
    					from.SendLocalizedMessage( 1060640 );//The item must be in your backpack to use it.
               else if( weap.BlessedFor != null && weap.BlessedFor != from )
					 from.SendMessage( "Toto neni tvuj predmet" );
               else if( weap is CrusadersWarMace )
					 from.SendMessage( "Na tuto zbran nelze svitek pouzit" );
    				else
    				{
                  from.SendGump( new InternalGump( weap, m_Scroll ) );
               }
    			}
    			else
    				from.SendMessage( "Svitek lze pouzit pouze na zbrane." );
    		}
    	}
		
		private class InternalGump : Gump
		{

			private Item m_Scroll;
			private BaseWeapon m_Weapon;
			
			public InternalGump( BaseWeapon weapon, Item scroll ) : base( 70, 70 )
			{
				m_Weapon = weapon;
				m_Scroll = scroll;
				
				this.Closable=true;
				this.Disposable=true;
				this.Dragable=true;
				this.Resizable=false;
            
            this.AddPage(0);
            this.AddBackground(0, 0, 255, 520, 9200);
            this.AddLabel(55, 7, 202, @"Zmenit ability zbrane:");
            
            int x = 0;
            int y = 0;
            int count = Enum.GetNames(typeof(WeaponAbility.AbilityType)).Length;
            
            for (int i = 0; i < count; ++i)
            {
               if ( i == 0 )
                  continue;

               if ( i == 21 )
               {
                  x = 160;
                  y = 0;
               }
               else if ( i == 11 )
               {
                  x = 80;
                  y = 0;
               }
               else if ( i != 1 )
                  y++;             
               
               AddImage( 10 + x, 35 + ( y * 45 ), 20991 + i );
               AddTooltip( 1028837 + i );
               AddButton( 55 + x, 46 + ( y * 45 ), 4005, 4006, i, GumpButtonType.Reply, 0 );
               
            }

            AddRadio(20, 495, 210, 211, true, 100);
            AddLabel(50, 495, 0, @"Primarni");
            AddRadio(130, 495, 210, 211, false, 101);
            AddLabel(165, 495, 0, @"Sekundarni");
			}

			public override void OnResponse(NetState sender, RelayInfo info)
			{
            Mobile from = sender.Mobile;
				
				if ( m_Weapon == null || m_Weapon.Deleted || m_Scroll == null || m_Scroll.Deleted )
					return;
               
  				if (info.ButtonID > 0)
  				{
               if ( info.ButtonID > Enum.GetNames(typeof(WeaponAbility.AbilityType)).Length )
                  return;
                  
               if ( m_Weapon is BaseRanged || m_Weapon is NoAmmoRanged || m_Weapon is MagicRanged ) //ranged
               {
                  if ( info.ButtonID == (int) WeaponAbility.AbilityType.WhirlwindAttack || info.ButtonID == (int) WeaponAbility.AbilityType.FrenziedWhirlwind ||  info.ButtonID == (int) WeaponAbility.AbilityType.DefenseMastery ||  
                  info.ButtonID == (int) WeaponAbility.AbilityType.DualWield ||  info.ButtonID == (int) WeaponAbility.AbilityType.Block )
                  {
                     from.SendMessage(1161, "Tuto abilitu nelze pridat na strelnou zbran");
                     return;
                  }
               }
               else //melee
               {
                  if ( info.ButtonID == (int) WeaponAbility.AbilityType.DoubleShot || info.ButtonID == (int) WeaponAbility.AbilityType.ForceArrow ||  info.ButtonID == (int) WeaponAbility.AbilityType.LightningArrow ||  
                  info.ButtonID == (int) WeaponAbility.AbilityType.PsychicAttack ||  info.ButtonID == (int) WeaponAbility.AbilityType.SerpentArrow ||  info.ButtonID == (int) WeaponAbility.AbilityType.MovingShot )
                  {
                     from.SendMessage(1161, "Tuto abilitu lze pridat pouze na strelnou zbran");
                     return;
                  }
               }
                                 
               if ( (int) m_Weapon.NewPrimaryAbility == info.ButtonID || (int) m_Weapon.NewSecondaryAbility == info.ButtonID )
               {
                  from.SendMessage(1161, "Tuto abilitu jiz zbran obsahuje");
                  return;
               }
               
               bool added = false;
               
               if ( info.IsSwitched( 100 ) )
               {
                  if ( (int) m_Weapon.NewPrimaryAbility == info.ButtonID )
                     from.SendMessage(1161, "Tuto primarni abilitu jiz zbran obsahuje");
                  else
                  {
                     added = true;
                     m_Weapon.NewPrimaryAbility = (WeaponAbility.AbilityType) info.ButtonID;
                  }
               }
               else
               {
                  if ( (int) m_Weapon.NewSecondaryAbility == info.ButtonID )
                     from.SendMessage(1161, "Tuto sekundarni abilitu jiz zbran obsahuje");
                  else
                  {
                     added = true;
                     m_Weapon.NewSecondaryAbility = (WeaponAbility.AbilityType) info.ButtonID;
                  }
               }
               
    				if ( added )
    				{
          			from.FixedParticles( 0x376A, 9, 32, 5007, EffectLayer.Waist );
          			from.PlaySound( 487 );
                  m_Scroll.Consume();
                  m_Weapon.BlessedFor = from;
                  from.SendMessage( "Zmena probehla uspesne" );               
               }
            }
			}
		}
	}
}


