using Server.Mobiles;
using Server.Network;
using System;

namespace Server.Items
{
    public class Collector2 : Item
    {
        public override bool Decays { get { return false; } }
        public override bool DisplayWeight { get { return false; } }

        private double i_Delay;
        private string m_Key1;
        private Point3D m_Key1_loc;
        private string m_Key2;
        private Point3D m_Key2_loc;
        private string m_Key3;
        private Point3D m_Key3_loc;
        private string m_Key4;
        private Point3D m_Key4_loc;
        private string m_Key5;
        private Point3D m_Key5_loc;

        private bool m_AllKeys;

        [CommandProperty(AccessLevel.GameMaster)]
        public double ResetDelay
        {
            get { return i_Delay; }
            set { i_Delay = value; }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public String Key1
        {
            get { return m_Key1; }
            set
            {
                string str = value;

                if (str != null)
                {
                    str = str.ToLower();
                    str = str.Trim();

                    Type type = SpawnerType.GetType(str);

                    if (type != null)
                        m_Key1 = str;
                    else
                        m_Key1 = "-invalid-";
                }
                else
                    m_Key1 = null;

                InvalidateProperties();
            }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public Point3D Key1_loc
        {
            get { return m_Key1_loc; }
            set { m_Key1_loc = value; }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public String Key2
        {
            get { return m_Key2; }
            set
            {
                string str = value;

                if (str != null)
                {
                    str = str.ToLower();
                    str = str.Trim();

                    Type type = SpawnerType.GetType(str);

                    if (type != null)
                        m_Key2 = str;
                    else
                        m_Key2 = "-invalid-";
                }
                else
                    m_Key2 = null;

                InvalidateProperties();
            }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public Point3D Key2_loc
        {
            get { return m_Key2_loc; }
            set { m_Key2_loc = value; }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public String Key3
        {
            get { return m_Key3; }
            set
            {
                string str = value;

                if (str != null)
                {
                    str = str.ToLower();
                    str = str.Trim();

                    Type type = SpawnerType.GetType(str);

                    if (type != null)
                        m_Key3 = str;
                    else
                        m_Key3 = "-invalid-";
                }
                else
                    m_Key3 = null;

                InvalidateProperties();
            }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public Point3D Key3_loc
        {
            get { return m_Key3_loc; }
            set { m_Key3_loc = value; }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public String Key4
        {
            get { return m_Key4; }
            set
            {
                string str = value;

                if (str != null)
                {
                    str = str.ToLower();
                    str = str.Trim();

                    Type type = SpawnerType.GetType(str);

                    if (type != null)
                        m_Key4 = str;
                    else
                        m_Key4 = "-invalid-";
                }
                else
                    m_Key4 = null;

                InvalidateProperties();
            }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public Point3D Key4_loc
        {
            get { return m_Key4_loc; }
            set { m_Key4_loc = value; }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public String Key5
        {
            get { return m_Key5; }
            set
            {
                string str = value;

                if (str != null)
                {
                    str = str.ToLower();
                    str = str.Trim();

                    Type type = SpawnerType.GetType(str);

                    if (type != null)
                        m_Key5 = str;
                    else
                        m_Key5 = "-invalid-";
                }
                else
                    m_Key5 = null;

                InvalidateProperties();
            }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public Point3D Key5_loc
        {
            get { return m_Key5_loc; }
            set { m_Key5_loc = value; }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public bool AllKeys
        {
            get { return m_AllKeys; }
            set { m_AllKeys = value; InvalidateProperties(); }
        }

        [Constructable]
        public Collector2() : this(1.0) { }

        [Constructable]
        public Collector2(double DelayTime) : base(13979)
        {
            Movable = false;
            // 			Name = "Collector";
            i_Delay = DelayTime;
            Light = LightType.Circle300;
        }

        // 		public override void AddNameProperties( ObjectPropertyList list )
        // 		{
        // 			base.AddNameProperties( list );
        // 			list.Add( "Seznam predmetu:" );
        // 			if (m_Key1 != null)
        // 			   list.Add( m_Key1 );
        // 			if (m_Key2 != null)
        // 			   list.Add( m_Key2 );
        // 			if (m_Key3 != null)
        // 			   list.Add( m_Key3 );
        // 			if (m_Key4 != null)
        // 			   list.Add( m_Key4 );
        // 			if (m_Key5 != null)
        // 			   list.Add( m_Key5 );
        // 		}

        public Collector2(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
            writer.Write((double)i_Delay);
            writer.Write(m_Key1);
            writer.Write((Point3D)m_Key1_loc);
            writer.Write(m_Key2);
            writer.Write((Point3D)m_Key2_loc);
            writer.Write(m_Key3);
            writer.Write((Point3D)m_Key3_loc);
            writer.Write(m_Key4);
            writer.Write((Point3D)m_Key4_loc);
            writer.Write(m_Key5);
            writer.Write((Point3D)m_Key5_loc);
            writer.Write((bool)m_AllKeys);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
            switch (version)
            {
                case 0:
                    {
                        i_Delay = reader.ReadDouble();
                        m_Key1 = reader.ReadString();
                        m_Key1_loc = reader.ReadPoint3D();
                        m_Key2 = reader.ReadString();
                        m_Key2_loc = reader.ReadPoint3D();
                        m_Key3 = reader.ReadString();
                        m_Key3_loc = reader.ReadPoint3D();
                        m_Key4 = reader.ReadString();
                        m_Key4_loc = reader.ReadPoint3D();
                        m_Key5 = reader.ReadString();
                        m_Key5_loc = reader.ReadPoint3D();
                        m_AllKeys = reader.ReadBool();
                        break;
                    }
            }

            if (m_AllKeys)
            {
                m_Timer = new ResetTimer(this, i_Delay);
                m_Timer.Start();
            }
        }

        public override void OnDoubleClick(Mobile from)
        {
            if (!from.InRange(this.GetWorldLocation(), 2))
            {
                from.SendLocalizedMessage(502138);
            }
            else if ((m_Key1 == "-invalid-" || m_Key1 == null) && (m_Key2 == "-invalid-" || m_Key2 == null)
                     && (m_Key3 == "-invalid-" || m_Key3 == null) && (m_Key4 == "-invalid-" || m_Key4 == null)
                     && (m_Key5 == "-invalid-" || m_Key5 == null))
            {
                from.SendMessage("Collector je spatne nastaven. Kontaktuj prosim Game mastera.");
            }
            else if (m_Key1_loc == Point3D.Zero && m_Key2_loc == Point3D.Zero && m_Key3_loc == Point3D.Zero && m_Key4_loc == Point3D.Zero && m_Key5_loc == Point3D.Zero)
            {
                from.SendMessage("Collector je spatne nastaveny. Kontaktuj prosim Game mastera.");
            }
            else if (m_AllKeys == true)
            {
                from.SendMessage("Je prilis brzy pro dalsi pouziti!");
            }
            else
            {

                Type typeKey1 = SpawnerType.GetType(m_Key1);
                Type typeKey2 = SpawnerType.GetType(m_Key2);
                Type typeKey3 = SpawnerType.GetType(m_Key3);
                Type typeKey4 = SpawnerType.GetType(m_Key4);
                Type typeKey5 = SpawnerType.GetType(m_Key5);

                bool Key1_placed = false;
                bool Key2_placed = false;
                bool Key3_placed = false;
                bool Key4_placed = false;
                bool Key5_placed = false;

                Item item1 = null;
                Item item2 = null;
                Item item3 = null;
                Item item4 = null;
                Item item5 = null;

                foreach (Item obj in from.GetItemsInRange(20))
                {
                    if (obj == null)
                        continue;

                    if (obj.GetType() == typeKey1 && obj.Location == m_Key1_loc)
                    {
                        Key1_placed = true;
                        item1 = obj;
                    }

                    if (obj.GetType() == typeKey2 && obj.Location == m_Key2_loc)
                    {
                        Key2_placed = true;
                        item2 = obj;
                    }

                    if (obj.GetType() == typeKey3 && obj.Location == m_Key3_loc)
                    {
                        Key3_placed = true;
                        item3 = obj;
                    }

                    if (obj.GetType() == typeKey4 && obj.Location == m_Key4_loc)
                    {
                        Key4_placed = true;
                        item4 = obj;
                    }

                    if (obj.GetType() == typeKey5 && obj.Location == m_Key5_loc)
                    {
                        Key5_placed = true;
                        item5 = obj;
                    }
                }

                if (Key1_placed == true && Key2_placed == true && Key3_placed == true && Key4_placed == true && Key5_placed == true)
                {
                    Effects.SendLocationParticles(EffectItem.Create(item1.Location, Map, EffectItem.DefaultDuration), 0x3709, 10, 30, 5052);
                    Effects.PlaySound(item1.Location, Map, 520);
                    Effects.SendMovingEffect(item1, this, 0x36D4, 2, 0, false, false);
                    item1.Delete();


                    Effects.SendLocationParticles(EffectItem.Create(item2.Location, Map, EffectItem.DefaultDuration), 0x3709, 10, 30, 5052);
                    Effects.PlaySound(item2.Location, Map, 520);
                    Effects.SendMovingEffect(item2, this, 0x36D4, 2, 0, false, false);
                    item2.Delete();

                    Effects.SendLocationParticles(EffectItem.Create(item3.Location, Map, EffectItem.DefaultDuration), 0x3709, 10, 30, 5052);
                    Effects.PlaySound(item3.Location, Map, 520);
                    Effects.SendMovingEffect(item3, this, 0x36D4, 2, 0, false, false);
                    item3.Delete();

                    Effects.SendLocationParticles(EffectItem.Create(item4.Location, Map, EffectItem.DefaultDuration), 0x3709, 10, 30, 5052);
                    Effects.PlaySound(item4.Location, Map, 520);
                    Effects.SendMovingEffect(item4, this, 0x36D4, 2, 0, false, false);
                    item4.Delete();


                    Effects.SendLocationParticles(EffectItem.Create(item5.Location, Map, EffectItem.DefaultDuration), 0x3709, 10, 30, 5052);
                    Effects.PlaySound(item5.Location, Map, 520);
                    Effects.SendMovingEffect(item5, this, 0x36D4, 2, 0, false, false);
                    item5.Delete();

                    m_AllKeys = true;
                    Effects.SendLocationParticles(EffectItem.Create(Location, Map, EffectItem.DefaultDuration), 14000, 9, 32, 5024);
                    Effects.PlaySound(Location, Map, 246);
                    Effects.PlaySound(Location, Map, 957);
                    Effects.PlaySound(Location, Map, 582);
                    PublicOverheadMessage(MessageType.Regular, 0x3B2, false, "Muhahaha...");

                    from.BoltEffect(0);
                    from.PlaySound(1471);
                    from.Hits = 1;

                    if (m_Timer != null)
                        m_Timer.Stop();

                    m_Timer = null;
                    m_Timer = new ResetTimer(this, i_Delay);

                    m_Timer.Start();
                }
                else
                    PublicOverheadMessage(MessageType.Regular, 0x3B2, false, "Nic se nedeje");
            }
        }

        public override void OnAfterDelete()
        {
            if (m_Timer != null)
                m_Timer.Stop();

            m_Timer = null;
            base.OnAfterDelete();
        }

        public void Empty()
        {
            if (m_Timer != null)
                m_Timer.Stop();

            m_Timer = null;

            InvalidateProperties();
            m_AllKeys = false;
        }

        private Timer m_Timer;

        private class ResetTimer : Timer
        {
            private Collector2 m_Barrel;

            public ResetTimer(Collector2 barrel, double i_Delay) : base(TimeSpan.FromMinutes(i_Delay))
            {
                m_Barrel = barrel;
                Priority = TimerPriority.FiveSeconds;
            }

            protected override void OnTick()
            {
                m_Barrel.Empty();
            }
        }
    }
}
