using System;
using Server;
using Server.Items;

namespace Server.Items
{
   public class DuchoBlok : Item
	{
		[Constructable]
		public DuchoBlok()
		{
         ItemID = 1293;
			Weight = 0.1;
         Visible = false;
         Movable = false;
			Name = "Blokovani mrtvych hracu";
			Hue = 1;
      }

      public DuchoBlok(Serial serial) : base(serial)
		{
		}
		
		private void EndMessageLock( object state )
		{
			((Mobile)state).EndAction( this );
		}

		public override bool OnMoveOver( Mobile m )
		{
			if ( m.AccessLevel > AccessLevel.Player )
				return true;

			if ( m.Player && !m.Alive )
			{
				if ( m.BeginAction( this ) )
				{
					m.SendMessage( "Jako duch nemuzes projit" );

					Timer.DelayCall( TimeSpan.FromSeconds( 5.0 ), new TimerStateCallback( EndMessageLock ), m );
				}
            
				return false;
			}

			return true;//base.OnMoveOver( m );
		}
		
      public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}