using System;
using Server;
using Server.Network;
using Server.Mobiles;

namespace Server.Items
{
	public class EventTeleporter : Teleporter
	{
		private int m_Players;
		private int m_PlayersMax;
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int Players
		{
			get { return m_Players; }
			set
         {
            m_Players = value;
            
            if ( m_Players >= m_PlayersMax )
            {
               this.Active = false;
               this.Visible = false;
            }
            else
            {
               this.Active = true;
               this.Visible = true;
            }
         }
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int PlayersMax
		{
			get { return m_PlayersMax; }
			set { m_PlayersMax = value; }
		}
		
		public override bool OnMoveOver( Mobile m )
		{
			if ( m.AccessLevel > AccessLevel.Player )
			{
            StartTeleport( m );
            return false;
         }
         
         if ( this.Active )
			{
				if ( !this.Creatures && !m.Player )
					return true;
    
    			if ( m.Player && m_Players >= m_PlayersMax && m.AccessLevel == AccessLevel.Player )
    			{
               m.SendMessage( "Touto branou jiz prosel maximalni povoleny pocet hracu." );
               return false; 
    			}
				
				StartTeleport( m );
				m_Players++;
				
            if ( m_Players >= m_PlayersMax )
            {
               this.Active = false;
               this.Visible = false;
            }
            
				return false;
			}

			return true;
		}
		
		[Constructable]
		public EventTeleporter()
		{
			Visible = true;
			ItemID = 3948;
			m_PlayersMax = 6;
			m_Players = 0;
		}
		
		public EventTeleporter( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int)0 ); // version

			writer.Write( (int) m_Players );
			writer.Write( (int) m_PlayersMax );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();

			m_Players = reader.ReadInt();
			m_PlayersMax = reader.ReadInt();
		}
	}
}
