using System;
using Server;
using Server.Network;

namespace Server.Items
{
	public class GivingTeleporter : Teleporter
	{
		private bool m_GiveMaxFame;
		private int m_GiveGold;
		private int m_GiveTokens;
		private bool m_Active, m_Creatures;
		private int m_GiveTitle = 0;
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int GiveGold
		{
			get { return m_GiveGold; }
			set { m_GiveGold = value; InvalidateProperties(); }
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int GiveTokens
		{
			get { return m_GiveTokens; }
			set { m_GiveTokens = value; InvalidateProperties(); }
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public bool Active
		{
			get { return m_Active; }
			set { m_Active = value; InvalidateProperties(); }
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public bool Creatures
		{
			get { return m_Creatures; }
			set { m_Creatures = value; InvalidateProperties(); }
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public bool GiveMaxFame
		{
			get{ return m_GiveMaxFame; }
			set{ m_GiveMaxFame = value; InvalidateProperties(); }
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int GiveTitle
		{
			get { return m_GiveTitle; }
			set { m_GiveTitle = value; InvalidateProperties(); }
		}

		public override bool OnMoveOver( Mobile m )
		{
			if ( m_Active )
			{
				if ( !m_Creatures && !m.Player )
					return true;

				if ( m_GiveMaxFame )
					m.Fame = 15000;
					
				if ( m_GiveGold > 0 )
				{
               if ( m_GiveGold > 999 )
                  m.AddToBackpack( new BankCheck( m_GiveGold ) );
               else
                  m.AddToBackpack( new Gold( m_GiveGold ) );
            }
            
				if ( m_GiveTokens > 0 )
				{
               if ( m_GiveTokens > 99 )
                  m.AddToBackpack( new TokenCheck( m_GiveTokens ) );
               else
                  m.AddToBackpack( new Tokens( m_GiveTokens ) );
            }
            
            if ( m_GiveTitle > 0 )
               PlayerTitles.AddTitle( m, m_GiveTitle );
				
				StartTeleport( m );
				return false;
			}

			return true;
		}
		
		[Constructable]
		public GivingTeleporter()
		{
			ItemID = 0xF6C;
			Hue = 721;
			Light = LightType.Circle300;
			Visible = true;
			Name = "Moongate";			
		}
		
		public GivingTeleporter( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 1 ); // version

			writer.Write( (int) m_GiveTitle );
         
         writer.Write( (bool) m_GiveMaxFame );
			writer.Write( (int) m_GiveGold );
			writer.Write( (int) m_GiveTokens );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			switch( version )
			{
				case 1:
				{
					m_GiveTitle = reader.ReadInt();
					goto case 0;
				}
            case 0:
				{
      			m_GiveMaxFame = reader.ReadBool();
      			m_GiveGold = reader.ReadInt();
      			m_GiveTokens = reader.ReadInt();
					break;
				}
			}
         
			m_Active = true;
		}
	}
}
