using Server.Network;
using System;
using System.Collections.Generic;

namespace Server.Items
{
    public class KeyCollector : Container
    {
        public override int DefaultMaxWeight { get { return 0; } } // A value of 0 signals unlimited weight
        public override bool Decays { get { return false; } }
        public override bool DisplayWeight { get { return false; } }
        public override bool DisplaysContent { get { return false; } }
        public override bool IsPublicContainer { get { return true; } }
        public override bool IsDecoContainer { get { return false; } }
        // 		public override string DefaultName { get { return "Collector"; } }

        private double i_Delay;
        private string m_Key1;
        private bool m_Key1_vhozen;
        private string m_Key2;
        private bool m_Key2_vhozen;
        private string m_Key3;
        private bool m_Key3_vhozen;
        private string m_Key4;
        private bool m_Key4_vhozen;
        private string m_Key5;
        private bool m_Key5_vhozen;
        private string m_Key6;
        private bool m_Key6_vhozen;

        private bool m_AllKeys;

        [CommandProperty(AccessLevel.GameMaster)]
        public double DeleteDelay
        {
            get { return i_Delay; }
            set { i_Delay = value; }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public String Key1
        {
            get { return m_Key1; }
            set
            {
                string str = value;

                if (str != null)
                {
                    str = str.ToLower();
                    str = str.Trim();
                    m_Key1 = str;
                }
                else
                    m_Key1 = null;

                InvalidateProperties();
            }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public bool Key1_vhozen
        {
            get { return m_Key1_vhozen; }
            set { m_Key1_vhozen = value; InvalidateProperties(); }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public String Key2
        {
            get { return m_Key2; }
            set
            {
                string str = value;

                if (str != null)
                {
                    str = str.ToLower();
                    str = str.Trim();
                    m_Key2 = str;
                }
                else
                    m_Key2 = null;

                InvalidateProperties();
            }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public bool Key2_vhozen
        {
            get { return m_Key2_vhozen; }
            set { m_Key2_vhozen = value; InvalidateProperties(); }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public String Key3
        {
            get { return m_Key3; }
            set
            {
                string str = value;

                if (str != null)
                {
                    str = str.ToLower();
                    str = str.Trim();
                    m_Key3 = str;
                }
                else
                    m_Key3 = null;

                InvalidateProperties();
            }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public bool Key3_vhozen
        {
            get { return m_Key3_vhozen; }
            set { m_Key3_vhozen = value; InvalidateProperties(); }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public String Key4
        {
            get { return m_Key4; }
            set
            {
                string str = value;

                if (str != null)
                {
                    str = str.ToLower();
                    str = str.Trim();
                    m_Key4 = str;
                }
                else
                    m_Key4 = null;

                InvalidateProperties();
            }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public bool Key4_vhozen
        {
            get { return m_Key4_vhozen; }
            set { m_Key4_vhozen = value; InvalidateProperties(); }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public String Key5
        {
            get { return m_Key5; }
            set
            {
                string str = value;

                if (str != null)
                {
                    str = str.ToLower();
                    str = str.Trim();
                    m_Key5 = str;
                }
                else
                    m_Key5 = null;

                InvalidateProperties();
            }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public bool Key5_vhozen
        {
            get { return m_Key5_vhozen; }
            set { m_Key5_vhozen = value; InvalidateProperties(); }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public String Key6
        {
            get { return m_Key6; }
            set
            {
                string str = value;

                if (str != null)
                {
                    str = str.ToLower();
                    str = str.Trim();
                    m_Key6 = str;
                }
                else
                    m_Key6 = null;

                InvalidateProperties();
            }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public bool Key6_vhozen
        {
            get { return m_Key6_vhozen; }
            set { m_Key6_vhozen = value; InvalidateProperties(); }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public bool AllKeys
        {
            get { return m_AllKeys; }
            set { m_AllKeys = value; InvalidateProperties(); }
        }

        [Constructable]
        public KeyCollector() : this(2.0) { }

        [Constructable]
        public KeyCollector(double DelayTime) : base(0x9A8)
        {
            Movable = false;
            LiftOverride = false;
            Name = "Collector";
            i_Delay = DelayTime;
        }

        public override void AddNameProperties(ObjectPropertyList list)
        {
            base.AddNameProperties(list);
            list.Add("Seznam predmetu:");
            if (m_Key1 != null)
                list.Add(1060658, "{0}\t{1}", m_Key1.ToString(), (m_Key1_vhozen) ? "Ano" : "<basefont color=Red>Ne<basefont color=White>");
            if (m_Key2 != null)
                list.Add(1060659, "{0}\t{1}", m_Key2.ToString(), (m_Key2_vhozen) ? "Ano" : "<basefont color=Red>Ne<basefont color=White>");
            if (m_Key3 != null)
                list.Add(1060660, "{0}\t{1}", m_Key3.ToString(), (m_Key3_vhozen) ? "Ano" : "<basefont color=Red>Ne<basefont color=White>");
            if (m_Key4 != null)
                list.Add(1060661, "{0}\t{1}", m_Key4.ToString(), (m_Key4_vhozen) ? "Ano" : "<basefont color=Red>Ne<basefont color=White>");
            if (m_Key5 != null)
                list.Add(1060662, "{0}\t{1}", m_Key5.ToString(), (m_Key5_vhozen) ? "Ano" : "<basefont color=Red>Ne<basefont color=White>");
            if (m_Key6 != null)
                list.Add(1060663, "{0}\t{1}", m_Key6.ToString(), (m_Key6_vhozen) ? "Ano" : "<basefont color=Red>Ne<basefont color=White>");
        }

        public override void GetProperties(ObjectPropertyList list)
        {
            base.GetProperties(list);
            Server.Engines.XmlSpawner2.XmlAttach.AddAttachmentProperties(this, list);
        }

        public KeyCollector(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
            writer.Write((double)i_Delay);
            writer.Write(m_Key1);
            writer.Write((bool)m_Key1_vhozen);
            writer.Write(m_Key2);
            writer.Write((bool)m_Key2_vhozen);
            writer.Write(m_Key3);
            writer.Write((bool)m_Key3_vhozen);
            writer.Write(m_Key4);
            writer.Write((bool)m_Key4_vhozen);
            writer.Write(m_Key5);
            writer.Write((bool)m_Key5_vhozen);
            writer.Write(m_Key6);
            writer.Write((bool)m_Key6_vhozen);
            writer.Write((bool)m_AllKeys);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
            switch (version)
            {
                case 0:
                    {
                        i_Delay = reader.ReadDouble();
                        m_Key1 = reader.ReadString();
                        m_Key1_vhozen = reader.ReadBool();
                        m_Key2 = reader.ReadString();
                        m_Key2_vhozen = reader.ReadBool();
                        m_Key3 = reader.ReadString();
                        m_Key3_vhozen = reader.ReadBool();
                        m_Key4 = reader.ReadString();
                        m_Key4_vhozen = reader.ReadBool();
                        m_Key5 = reader.ReadString();
                        m_Key5_vhozen = reader.ReadBool();
                        m_Key6 = reader.ReadString();
                        m_Key6_vhozen = reader.ReadBool();
                        m_AllKeys = reader.ReadBool();
                        break;
                    }
            }

            if (Items.Count > 0)
            {
                m_Timer = new EmptyTimer(this, i_Delay);
                m_Timer.Start();
            }
        }

        public override bool OnDragDrop(Mobile from, Item dropped)
        {
            if (m_Key1 == null && m_Key2 == null && m_Key3 == null && m_Key4 == null && m_Key5 == null && m_Key6 == null)
            {
                from.SendMessage("{0} je spatne nastaven. Kontaktuj prosim Game mastera.", this.Name);
                return false;
            }

            if (dropped is Klic)
            {
                string DroppedName = dropped.Name.ToLower();

                if (DroppedName == null)
                {
                    from.SendMessage("Nespravny predmet");
                    return false;
                }

                //kontrola jestli je spravne jmeno
                if ((DroppedName == m_Key1) || (DroppedName == m_Key2) ||
                    (DroppedName == m_Key3) || (DroppedName == m_Key4) ||
                    (DroppedName == m_Key5) || (DroppedName == m_Key6))
                {
                    if ((DroppedName == m_Key1 && m_Key1 != null && m_Key1_vhozen == true) ||
                        (DroppedName == m_Key2 && m_Key2 != null && m_Key2_vhozen == true) ||
                        (DroppedName == m_Key3 && m_Key3 != null && m_Key3_vhozen == true) ||
                        (DroppedName == m_Key4 && m_Key4 != null && m_Key4_vhozen == true) ||
                        (DroppedName == m_Key5 && m_Key5 != null && m_Key5_vhozen == true) ||
                        (DroppedName == m_Key6 && m_Key6 != null && m_Key6_vhozen == true))
                    {
                        from.SendMessage("Tento predmet je jiz v {0} umisten.", this.Name);
                        return false;
                    }
                    else //ok
                    {
                        if (dropped.Amount > 1)
                        {
                            from.SendMessage("Mnozstvi vhazovaneho predmetu nesmi byt vetsi nez 1.");
                            return false;
                        }

                        if (DroppedName == m_Key1 && m_Key1 != null)
                            m_Key1_vhozen = true;
                        else if (DroppedName == m_Key2 && m_Key2 != null)
                            m_Key2_vhozen = true;
                        else if (DroppedName == m_Key3 && m_Key3 != null)
                            m_Key3_vhozen = true;
                        else if (DroppedName == m_Key4 && m_Key4 != null)
                            m_Key4_vhozen = true;
                        else if (DroppedName == m_Key5 && m_Key5 != null)
                            m_Key5_vhozen = true;
                        else if (DroppedName == m_Key6 && m_Key6 != null)
                            m_Key6_vhozen = true;

                        bool k1 = (m_Key1 != null) ? true : false;
                        bool k2 = (m_Key2 != null) ? true : false;
                        bool k3 = (m_Key3 != null) ? true : false;
                        bool k4 = (m_Key4 != null) ? true : false;
                        bool k5 = (m_Key5 != null) ? true : false;
                        bool k6 = (m_Key6 != null) ? true : false;

                        if ((m_Key1_vhozen == k1) && (m_Key2_vhozen == k2)
                            && (m_Key3_vhozen == k3) && (m_Key4_vhozen == k4)
                            && (m_Key5_vhozen == k5) && (m_Key6_vhozen == k6))
                        {
                            m_AllKeys = true;
                            Effects.SendLocationParticles(EffectItem.Create(Location, Map, EffectItem.DefaultDuration), 0x376A, 9, 32, 5024);
                            Effects.PlaySound(Location, Map, 0x1FF);
                            from.SendMessage("V {0} jsou nyni umisteny vsechny pozadovane predmety.", this.Name);
                        }
                        else
                            from.SendMessage("{0} byl umisten do {1}.", dropped.Name, this.Name);

                        from.SendMessage("{0} bude vyprazdnen za {1} minuty.", this.Name, i_Delay);

                        if (m_Timer != null)
                            m_Timer.Stop();

                        m_Timer = null;
                        m_Timer = new EmptyTimer(this, i_Delay);

                        m_Timer.Start();
                        return base.OnDragDrop(from, dropped);
                    }
                }
                else
                {
                    from.SendMessage("Toto neni spravny predmet.");
                    return false;
                }
            }
            else
            {
                from.SendMessage("Tento predmet nelze do {0} umistit.", this.Name);
                return false;
            }
        }

        // 		public override bool OnDragDropInto( Mobile from, Item item, Point3D p )
        // 		{
        // 			from.SendMessage( "Predmet byl umisten do colectoru." );
        // 
        // 			if ( m_Timer != null )
        // 				m_Timer.Stop();
        // 			else
        // 				m_Timer = new EmptyTimer( this, i_Delay );
        // 
        // 			m_Timer.Start();
        // 			return base.OnDragDropInto( from, item, p );
        // 		}

        public override void OnDoubleClick(Mobile from)
        {
            if ((int)from.AccessLevel > (int)AccessLevel.Player)
                base.OnDoubleClick(from);
        }

        public override bool CheckLift(Mobile from, Item item, ref LRReason reject)
        {
            if ((int)from.AccessLevel > (int)AccessLevel.Player)
                return base.CheckLift(from, item, ref reject);
            else
                reject = LRReason.CannotLift;

            return false;
        }

        public override void DisplayTo(Mobile m)
        {
            if ((int)m.AccessLevel > (int)AccessLevel.Player)
                base.DisplayTo(m);
        }

        public override void OnItemUsed(Mobile from, Item item)
        {
            if ((int)from.AccessLevel > (int)AccessLevel.Player)
                base.OnItemUsed(from, item);
        }

        public void Empty()
        {
            List<Item> items = this.Items;

            if (items.Count > 0)
            {
                PublicOverheadMessage(MessageType.Regular, 0x3B2, false, String.Format("*{0} byl vyprazdnen*", this.Name));
                Effects.SendLocationParticles(EffectItem.Create(Location, Map, EffectItem.DefaultDuration), 0x3728, 8, 20, 5042);
                Effects.PlaySound(Location, Map, 0x201);

                for (int i = items.Count - 1; i >= 0; --i)
                {
                    if (i >= items.Count)
                        continue;

                    items[i].Delete();
                }
            }

            if (m_Timer != null)
                m_Timer.Stop();

            m_Timer = null;

            m_Key1_vhozen = false;
            m_Key2_vhozen = false;
            m_Key3_vhozen = false;
            m_Key4_vhozen = false;
            m_Key5_vhozen = false;
            m_Key6_vhozen = false;
            InvalidateProperties();
            m_AllKeys = false;
        }

        public override void OnAfterDelete()
        {
            if (m_Timer != null)
                m_Timer.Stop();

            m_Timer = null;
            base.OnAfterDelete();
        }

        private Timer m_Timer;

        private class EmptyTimer : Timer
        {
            private KeyCollector m_Barrel;

            public EmptyTimer(KeyCollector barrel, double i_Delay) : base(TimeSpan.FromMinutes(i_Delay))
            {
                m_Barrel = barrel;
                Priority = TimerPriority.FiveSeconds;
            }

            protected override void OnTick()
            {
                m_Barrel.Empty();
            }
        }
    }
}
