using System;
using Server;
using Server.Gumps;
using Server.Network;
using Server.Multis;
using Server.ContextMenus;
using System.Collections;
using System.Collections.Generic;
// using Server.Engines.Craft;

namespace Server.Items
{
	[FlipableAttribute( 0x2AC0, 0x2AC3 )]
	public class MagicFountain : Item, ISecurable
	{
		private int m_uses;
		private int m_maxuses = 300;
		private SecureLevel m_Level;
		
		public override bool DisplayWeight { get { return false; } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public SecureLevel Level
		{
			get{ return m_Level; }
			set{ m_Level = value; }
		}
		
      [Constructable]
		public MagicFountain() : base( 0x2AC0 )
		{
			Name = "Magicka fontana";
			Weight = 20;
			m_uses = m_maxuses;
			Movable = true;
		}

		public override void GetContextMenuEntries( Mobile from, List<ContextMenuEntry> list )
		{
			base.GetContextMenuEntries( from, list );

			SetSecureLevelEntry.AddTo( from, this, list );
		}
		
		public MagicFountain ( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 1 ); // version
			
			writer.WriteEncodedInt( (int) m_Level );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
			
			switch( version )
			{
				case 1:
				{
					m_Level = (SecureLevel) reader.ReadEncodedInt();
					goto case 0;
				}
            case 0:
				{
					break;
				}
			}
			
			m_uses = m_maxuses;
		}

		public override void OnDoubleClick ( Mobile from )
		{
			if ( from.InRange( GetWorldLocation(), 2 ) )
			{
				if ( m_uses > 0 )
					from.SendMessage( "Ve fontane lze namocit {0} obvazu.", m_uses );
				else
					from.SendMessage( "Magicka sila fontany je vycerpana." );
				return;
			}
			else
			{
				from.SendLocalizedMessage ( 500295 ); // You are too far away to do that.
			}
		}
		
		public override bool OnDragDrop( Mobile from, Item dropped )
		{
			if ( !IsSecure && this.Movable == true )
			{
			   from.SendMessage( "Musi byt secured v dome" );
            return false;
         }
         
			if ( this.Movable == true && !BaseHouse.CheckAccessible( from, this ) )
			{
			   from.SendMessage( "Nemas k fontane pristup" );
            return false;
         }			   
        
         if ( m_uses > 0 )
			{
				if ( from.Backpack != null )
				{
					if( dropped is Bandage )
					{
						from.RevealingAction();
						int amount = dropped.Amount;
						
						if ( m_uses >= amount )
						{
							from.AddToBackpack( new EnhancedBandage( amount ) );
							m_uses -= amount;
						}
						else
						{
							from.AddToBackpack( new EnhancedBandage( m_uses ) );
							from.AddToBackpack( new Bandage( amount - m_uses ) );
							m_uses = 0;
						}
						
						dropped.Delete();
						from.LocalOverheadMessage( MessageType.Regular, 0x22, true, "Obvazy byly posileny magickou silou." );
						Effects.PlaySound( this.Location, this.Map, 0x4E );
						
						if ( m_Timer != null )
							m_Timer.Stop();
						else
							m_Timer = new MagicFountainTimer( this );
						
						m_Timer.Start();
						
						if ( m_uses < 1 )
						{
							from.SendMessage ( "Magicka sila fontany je vycerpana." );
						}

						return true;
					}
					else if( dropped is EnhancedBandage )
					{
						from.SendMessage("tyto obvazy jsou jiz namocene.");
					}
					else
					{
						from.SendMessage("Ve fontane muzes namocit pouze obvazy.");
					}
					return false;
				}
				else
				{
					from.SendMessage("You don't have a backpack to hold the enhanced bandages! Begone!");
					return false;
				}
			}
			else
			{
				from.SendMessage ( "Magicka sila fontany je vycerpana." );
				return false;
			}
		}
		
		public override void OnAfterDelete()
		{
			if ( m_Timer != null )
				m_Timer.Stop();
				
			m_Timer = null;
			base.OnAfterDelete();
		}
		
		public void RestoreMagic()
		{
			m_uses += 5;
			if ( m_uses >= m_maxuses )
			{
				m_uses = m_maxuses;
				if ( m_Timer != null )
					m_Timer.Stop();
				
				m_Timer = null;
				PublicOverheadMessage( MessageType.Regular, 0x3B2, false, "*Magicka zare kolem fontany se obnovila*" );
			}
			
			Effects.SendLocationParticles(
				EffectItem.Create( this.Location, this.Map, EffectItem.DefaultDuration ),
				0x376A, 9, 32, 5024 );
			Effects.PlaySound( this.Location, this.Map, 0x1EB );
		}

		private Timer m_Timer;

		private class MagicFountainTimer : Timer
		{
			private MagicFountain m_Fountain;

			public MagicFountainTimer( MagicFountain fountain ) : base( TimeSpan.FromMinutes( 1.0 ), TimeSpan.FromMinutes( 1.0 ) )
			{
				m_Fountain = fountain;
				Priority = TimerPriority.OneMinute;
			}

			protected override void OnTick()
			{
				m_Fountain.RestoreMagic();
			}
		}
// 		
// 		#region ICraftable Members
// 
// 		public override int OnCraft( int quality, bool makersMark, Mobile from, CraftSystem craftSystem, Type typeRes, BaseTool tool, CraftItem craftItem, int resHue )
// 		{
// 			Type resourceType = typeRes;
// 
// 			if ( resourceType == null )
// 				resourceType = craftItem.Ressources.GetAt( 0 ).ItemType;
// 
// 			CraftResource Resource = CraftResources.GetFromType( resourceType );
// 
// 			CraftContext context = craftSystem.GetContext( from );
// 
// 			if ( context != null && context.DoNotColor )
// 				resHue = 0;
//          else
// 			   resHue = CraftResources.GetHue( Resource );
// 
// 			return 1;
// 		}
// 
// 		#endregion
	}
}
