using System;
using Server;
using Server.Network;
using Server.Mobiles;

namespace Server.Items
{
	public class NoMedicTeleporter : Teleporter
	{
		private bool m_NoMedic;
		
		[CommandProperty( AccessLevel.GameMaster )]
		public bool NoMedic
		{
			get { return m_NoMedic; }
			set { m_NoMedic = value; InvalidateProperties(); }
		}
		
		private void EndMessageLock( object state )
		{
			((Mobile)state).EndAction( this );
		}
		
		public override bool OnMoveOver( Mobile m )
		{
			if ( this.Active )
			{
				if ( !this.Creatures && !m.Player )
					return true;
    
    			if ( m.Player && m_NoMedic && m.AccessLevel == AccessLevel.Player )
    			{
                BaseHire hire = BaseHire.HireTable[m] as BaseHire;
    
                if( hire != null && !hire.Deleted && hire.GetOwner() == m && hire is Medic ) 
                { 
					    if ( m.BeginAction( this ) )
					    {
						   m.SendMessage( "Nemuzes projit pokud te doprovazi medik." );

						   Timer.DelayCall( TimeSpan.FromSeconds( 5.0 ), new TimerStateCallback( EndMessageLock ), m );
					    }
                   return false; 
                } 
    			}
				
				StartTeleport( m );
				return false;
			}

			return true;
		}
		
		[Constructable]
		public NoMedicTeleporter()
		{
			Visible = false;
			Name = "Teleport bez medika";
			m_NoMedic = true;
		}
		
		public NoMedicTeleporter( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int)0 ); // version

			writer.Write( (bool) m_NoMedic );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();

			m_NoMedic = reader.ReadBool();
		}
	}
}
