using System;
using Server;
using Server.Network;
using Server.Mobiles;

namespace Server.Items
{
	public class SoutezniGate : ConfirmationMoongate
	{
		private int m_Exp = 1;
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int Exp
		{
			get { return m_Exp; }
			set
         {
            m_Exp = value;
            Name = String.Format( "Soutezni Brana [Body: {0}]", m_Exp );
            MessageString = String.Format( "Za projiti branou ziskas {0} bodu pokud mas odehrano mene nez 31 dni.<br><br>Opravdu chces branou projit?", m_Exp );
         }
		}
		
		[Constructable]
		public SoutezniGate()
		{
			Exp = m_Exp;
			Hue = 1951;
			Dispellable = false;

			GumpWidth = 300;
			GumpHeight = 200;

			MessageColor = 55000;
			MessageNumber = 0;
			MessageString = String.Format( "Za projiti branou ziskas {0} bodu.<br><br>Opravdu chces branou projit?", m_Exp );

			TitleColor = 0x7800;
			TitleNumber = 1062108; // Please verify...

			Name = String.Format( "Soutezni Brana [Body: {0}]", m_Exp );
		}
		
		public override void OnGateUsed( Mobile m )
		{
         if ( m is PlayerMobile && ((PlayerMobile)m).GameTime.Days < 31 )
         {
            ((PlayerMobile)m).Expy += m_Exp;
            m.SendMessage( 0x35, "Pocet ziskanych bodu: {0}", m_Exp );
            m.SendMessage( 0x35, "Aktualni pocet tvych bodu: {0}", ((PlayerMobile)m).Expy );
         }		
		}
		
		public SoutezniGate( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int)0 ); // version

			writer.Write( (int) m_Exp );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();

			m_Exp = reader.ReadInt();
		}
	}
}
