using System;
using Server;
using Server.Network;
using Server.Mobiles;

namespace Server.Items
{
	public class StatsTeleporter : Teleporter
	{
		private int m_StatsMin;
		private int m_StatsMax;

		[CommandProperty( AccessLevel.GameMaster )]
		public int StatsMin
		{
			get{ return m_StatsMin; }
			set{ m_StatsMin = value; InvalidateProperties(); }
		}

		[CommandProperty( AccessLevel.GameMaster )]
		public int StatsMax
		{
			get{ return m_StatsMax; }
			set{ m_StatsMax = value; InvalidateProperties(); }
		}

		private void EndMessageLock( object state )
		{
			((Mobile)state).EndAction( this );
		}

		public override bool OnMoveOver( Mobile m )
		{
			if ( Active )
			{
				if ( !Creatures && !m.Player )
					return true;

				int stats = m.RawStatTotal;
				
            if ( m.AccessLevel == AccessLevel.Player && ( stats < m_StatsMin || stats > m_StatsMax ) )
				{
					if ( m.BeginAction( this ) )
					{
						m.SendMessage( "Nemuzes projit pokud mas soucet statu bez bonusu mensi nez {0} nebo vetsi nez {1}.", m_StatsMin, m_StatsMax );

						Timer.DelayCall( TimeSpan.FromSeconds( 5.0 ), new TimerStateCallback( EndMessageLock ), m );
					}

					return false;
				}

				StartTeleport( m );
				return false;
			}

			return true;
		}

		[Constructable]
		public StatsTeleporter()
		{
			Visible = false;
			Name = "Stats Teleporter";
			m_StatsMin = 100;
			m_StatsMax = 200;
		}

		public StatsTeleporter( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version

			writer.Write( (int) m_StatsMin );
			writer.Write( (int) m_StatsMax );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			switch ( version )
			{
				case 0:
				{
					m_StatsMin = reader.ReadInt();
					m_StatsMax = reader.ReadInt();

					break;
				}
			}
		}
	}
}
