using System;
using Server;
using Server.Gumps;
using Server.Network;
using Server.Commands;
using Server.Mobiles;
using System.Collections;
using System.Collections.Generic;

namespace Server.Gumps
{
	public class ExpyBoardGump : Gump
	{
		public static void Initialize()
		{
			CommandSystem.Register("Expy", AccessLevel.GameMaster, new CommandEventHandler(ExpyBoardGump_OnCommand));
		}

		[Usage("Expy")]
		[Description("Zobrazi to 10 hracu s nejvice expama.")]
		public static void ExpyBoardGump_OnCommand(CommandEventArgs e)
		{
			if (e.Mobile.HasGump(typeof(ExpyBoardGump)))
				e.Mobile.CloseGump(typeof(ExpyBoardGump));
			e.Mobile.SendGump(new ExpyBoardGump());
		}
		
		private class ListAmountSorter : IComparer
		{
			public ListAmountSorter() : base()
			{
			}

			public int Compare(object x, object y)
			{
				if (x == null || y == null || x == y || !(x is PlayerMobile) || !(y is PlayerMobile)) return 0;
				if (((PlayerMobile)x).Expy == ((PlayerMobile)y).Expy)
				{
					return ((Mobile)x).RawName.CompareTo( ((Mobile)y).RawName );
				}
				return ((((PlayerMobile)x).Expy > ((PlayerMobile)y).Expy) ? -1 : 1);
			}
		}
		
		ArrayList ExpyArray = new ArrayList();

		public ExpyBoardGump() : base( 200, 150 )
		{
			this.Closable=true;
			this.Disposable=true;
			this.Dragable=true;
			this.Resizable=false;
			
			int pocetZubu = 0;
			int pocetHracu = 0;
			List<Mobile> mobs = new List<Mobile>( World.Mobiles.Values );
			foreach ( Mobile m in mobs )
			{
				if ( m is PlayerMobile )
				{
					PlayerMobile pm = (PlayerMobile) m;
					
					if ( pm.Expy != null && pm.Expy > 0 )
					{
						pocetZubu += pm.Expy;
						pocetHracu++;
						ExpyArray.Add(pm);
					}
				}
			}

			AddPage(0);
			AddImage(0, 0, 2170);
			AddLabel(171, 28, 1152, @"Vysledkova tabule");
			AddLabel(171, 46, 1152, @"10 nejlepsich soutezicich");
			AddLabel(120, 117, 0, @"Jmeno");
			AddLabel(316, 117, 0, @"Pocet");
			AddLabel(117, 343, 0, String.Format( "{0} hracu ziskalo celkem {1} bodu", pocetHracu, pocetZubu ));
			
			if (ExpyArray != null && ExpyArray.Count > 0)
			{
				ExpyArray.Sort(new ListAmountSorter());
				int count = ExpyArray.Count > 9 ? 10 : ExpyArray.Count;
				int y = 156;
				
				for (int i = 0; i < count; i++)
				{
					if (ExpyArray[i] == null || !(ExpyArray[i] is PlayerMobile)) { break; }
					else
					{
						PlayerMobile pm = (PlayerMobile) ExpyArray[i];
						
						AddLabel(119, y, 0, String.Format( "{0}. {1}", i+1, pm.RawName ));
						AddLabel(321, y, 0, String.Format( "{0}", pm.Expy ));
					}
					
					y += 15;
				}
			}
			else
				AddLabel(119, 200, 0, @"Zatim nikdo neziskal body v soutezi");
			
			ExpyArray.Clear();
		}

		public override void OnResponse(NetState sender, RelayInfo info)
		{
			Mobile from = sender.Mobile;

			switch(info.ButtonID)
			{
				case 0:
					{
						break;
					}

			}
		}
	}
}
namespace Server.Items
{
	[Flipable( 0x1E5E, 0x1E5F )]
   public class ExpyBoard : Item
	{
		[Constructable]
		public ExpyBoard() : base( 0x1E5E )
		{
			Movable = false;
			Hue = 51;
			Name = "Vysledkova Tabule";
		}

		public override void OnDoubleClick(Mobile from)
		{
			if ((!from.InRange(GetWorldLocation(), 3) || !from.InLOS(this)) && from.AccessLevel == AccessLevel.Player)
			{
				from.SendLocalizedMessage(500446); // That is too far away.
				return;
			}

			from.CloseGump(typeof(ExpyBoardGump));
			from.SendGump(new ExpyBoardGump());
		}
		
		public ExpyBoard(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);
			writer.Write((int)0); // version
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);
			int version = reader.ReadInt();
		}
	}
}
