﻿using System;
using System.Collections;
using Server;
using Server.Items;
using Server.Gumps;
using Server.Mobiles;
using Server.Targeting;
using Server.Network;

namespace Server.Items
{
	public class PetRetryStone : Item
	{
		private int m_CostToRetry;
		public override bool DisplayWeight { get { return false; } }

		[CommandProperty(AccessLevel.GameMaster)]
		public int CostToRetry
		{
			get { return m_CostToRetry; }
			set { m_CostToRetry = value; this.InvalidateProperties(); }
		}

		[Constructable]
		public PetRetryStone() : base(4484)
		{
			Name = "Kamen privolani zvirat";
			Movable = false;
			Hue = 1287;
			CostToRetry = 500;
		}

		public PetRetryStone(Serial serial) : base(serial)
		{
		}

		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);

			if (m_CostToRetry > 0)
			{
				list.Add("Cena za privolani: " + m_CostToRetry.ToString("N0") + " Zlatych.");
			}
		}

		public override void OnDoubleClick(Mobile from)
		{
			if (!from.InRange(this.GetWorldLocation(), 3))
				from.SendLocalizedMessage(502138);
			else
				from.SendGump(new PetRetryStoneGump((PlayerMobile)from, this, m_CostToRetry));
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0); // version

			writer.Write((int) m_CostToRetry);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();

			switch(version)
			{
				case 0:
				{
					m_CostToRetry = reader.ReadInt();
					break;
				}
			}
		}
	}
}

namespace Server.Gumps
{
	public class PetRetryStoneGump : Gump
	{
		private PetRetryStone m_Stone;
		private PlayerMobile m_From;

		public PetRetryStoneGump(PlayerMobile from, PetRetryStone stone, int cost)
		: base(75, 75)
		{
			m_Stone = stone;
			m_From = from;
			this.Closable = true;
			this.Disposable = true;
			this.Dragable = true;
			this.Resizable = false;
			this.AddPage(0);
			this.AddImage(60, 125, 30502);
			this.AddImage(169, 129, 71);
			if (cost > 0)
			{
				this.AddHtml(190, 143, 134, 77, @"<basefont color=white>Magie ukryta v tomto kameni dokaze privolat tva zvirata odkudkoliv na svete.", (bool)false, (bool)false);
				string costString = string.Format("<basefont color=white>Cena: <basefont color=#FFFFAA>{0} Zlatych<basefont color=white>", cost.ToString("N0"));
				this.AddHtml(189, 234, 133, 21, costString, (bool)false, (bool)false);
			}
			else
				this.AddHtml(190, 143, 134, 77, @"<basefont color=white>Magie ukryta v tomto kameni dokaze privolat tva zvirata odkudkoliv na svete.", (bool)false, (bool)false);

			this.AddButton(186, 264, 247, 248, (int)Buttons.Okay, GumpButtonType.Reply, 0);
			this.AddButton(260, 264, 242, 241, (int)Buttons.Cancel, GumpButtonType.Reply, 0);
		}

		public enum Buttons
		{
			Cancel,
			Okay
		}

		public override void OnResponse(NetState ns, RelayInfo info)
		{
			switch(info.ButtonID)
			{
				case (int)Buttons.Okay:
				{
					if (m_From is PlayerMobile)
					{
						Mobile master = (Mobile)m_From;
						ArrayList pets = new ArrayList();

						foreach (Mobile m in World.Mobiles.Values)
						{
							if (m is BaseCreature)
							{
								BaseCreature bc = (BaseCreature)m;

								if (!(bc is BaseSummoned) && ((bc.Controlled && bc.ControlMaster == master) || (bc.Summoned && bc.SummonMaster == master)))
								{
									if (master.Map == Map.Underworld && bc.Map != Map.Underworld)
										continue;

									pets.Add(bc);
								}
							}
						}

						if (pets.Count > 0)
						{
							if (ChargePlayer(m_From))
							{
								master.SendMessage("Privolani {0} {1}.", pets.Count, pets.Count != 1 ? "zvirat" : "zvire");

								for (int i = 0; i < pets.Count; ++i)
								{
									Mobile pet = (Mobile)pets[i];

									if (pet is IMount)
										((IMount)pet).Rider = null; // make sure it's dismounted

										pet.MoveToWorld(master.Location, master.Map);
								}
							}
						}
						else
						{
							master.SendMessage("Nebyla nalezena zadna zvirata v tvem vlastnictvi.");
						}
					}

					break;
				}

				case (int)Buttons.Cancel:
				{
					// 					m_From.SendMessage("You decide not to resurrect a pet.");
					break;
				}
			}
		}

		private bool ChargePlayer(PlayerMobile p)
		{
			int c_ress = m_Stone.CostToRetry;
			if (c_ress > 0)
			{
				if (Banker.Withdraw(p, c_ress))
				{
					p.SendLocalizedMessage(1060398, c_ress.ToString("N0")); // Amount charged
					p.SendLocalizedMessage(1060022, Banker.GetBalance(p).ToString("N0")); // Amount left, from bank
				}
				else
				{
					p.SendMessage("Nemas dostatek penez na privolani svych zvirat.");
					return false;
				}
			}

			return true;
		}
	}
}