using System;
using Server.Network;
using Server;
namespace Server.Items
{
	public class FollowerSlotPotion : BasePotion
	{
		[Constructable]
		public FollowerSlotPotion() : base( 0xEFC, PotionEffect.FollowerSlot )
		{
			Weight = 1.0;
			Movable = true;
			Name = "Napoj ovladani zvirat";
		}

		public FollowerSlotPotion( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
		
		public override void Drink( Mobile m )
		{
			if ( m.InRange( this.GetWorldLocation(), 1 ) )
			{
				if ( m.FollowersMax != 5 && m.Skills[SkillName.AnimalTaming].Base > 99.9 )
				{
					m.SendMessage( "Napoj lze vypit pouze pokud umis ovladat 5 zvirat a mas dovednost ochocovani nejmene 100!" );
				}
				else if ( m.Skills[SkillName.AnimalTaming].Base < 100.0 )
				{
					m.SendMessage( "Napoj lze vypit pouze pokud mas dovednost ochocovani nejmene 100!" );
				}
				else
				{
					m.FollowersMax = 7;
					this.Delete();
					m.SendMessage( "Nyni muzes ovladat az 7 zvirat!" );
					Effects.SendLocationParticles( EffectItem.Create( m.Location, m.Map, EffectItem.DefaultDuration ), 0, 0, 0, 0, 0, 5060, 0 );
					Effects.PlaySound( m.Location, m.Map, 0x243 );

					Effects.SendMovingParticles( new Entity( Serial.Zero, new Point3D( m.X - 6, m.Y - 6, m.Z + 15 ), m.Map ), m, 0x36D4, 7, 0, false, true, 0x497, 0, 9502, 1, 0, (EffectLayer)255, 0x100 );
					Effects.SendMovingParticles( new Entity( Serial.Zero, new Point3D( m.X - 4, m.Y - 6, m.Z + 15 ), m.Map ), m, 0x36D4, 7, 0, false, true, 0x497, 0, 9502, 1, 0, (EffectLayer)255, 0x100 );
					Effects.SendMovingParticles( new Entity( Serial.Zero, new Point3D( m.X - 6, m.Y - 4, m.Z + 15 ), m.Map ), m, 0x36D4, 7, 0, false, true, 0x497, 0, 9502, 1, 0, (EffectLayer)255, 0x100 );

					Effects.SendTargetParticles( m, 0x375A, 35, 90, 0x00, 0x00, 9502, (EffectLayer)255, 0x100 );
				}
			}
			else
			{
				m.LocalOverheadMessage( MessageType.Regular, 906, 1019045 ); // I can't reach that.
			}
		}
	}
}
