using System;
using System.IO;
using System.Collections;
using Server;
using Server.Misc;
using Server.Items;
using Server.Gumps;
using Server.Multis;
using Server.Engines.Help;
using Server.Network;
using Server.Mobiles;
using Server.Targeting;
using Server.Targets;
using System.Reflection;
using Server.Spells;
using Server.Spells.Fifth;
using Server.Spells.Seventh;
using Server.ContextMenus;
using Server.Regions;
//using Server.StaticHousing;
using Server.Accounting;
using Server.Prompts;
namespace Server.Targets
{
	public class RepairTarget : Target
	{
		public RepairTarget() :  base ( 1, false, TargetFlags.None )
		{
		}
		protected override void OnTarget( Mobile from, object targeted )
		{
			int number;
			if ( targeted is BaseArmor )
			{
				BaseArmor repairing = (BaseArmor)targeted;
				if ( !repairing.IsChildOf( from.Backpack ) )
				{
					from.SendLocalizedMessage( 1044275 ); // The item must be in your backpack to repair it.
				}
				else if ( repairing.HitPoints == repairing.MaxHitPoints )
				{
					from.SendLocalizedMessage( 1044281 );// That item is in full repair
				}
				else if ( repairing.MaxHitPoints <= 2 )
				{
					from.SendLocalizedMessage( 1044278 );// That item has been repaired many times, and will break if repairs are attempted again.
				}
				else
				{
					Container backpack = from.Backpack;
					RepairPotion repairpotion = (RepairPotion)backpack.FindItemByType(typeof(RepairPotion));
					if ( repairpotion != null )
					{
						from.SendLocalizedMessage( 1044279 ); // You repair the item.
						repairing.MaxHitPoints -= 2;
						repairing.HitPoints = repairing.MaxHitPoints;
						repairpotion.Consume();
						from.AddToBackpack( new Bottle() );
					}
				}
			}
			else if ( targeted is BaseClothing )
			{
				BaseClothing repairing3 = (BaseClothing)targeted;
				if ( !repairing3.IsChildOf( from.Backpack ) )
				{
					from.SendLocalizedMessage( 1044275 ); // The item must be in your backpack to repair it.
				}
				else if ( repairing3.HitPoints == repairing3.MaxHitPoints )
				{
					from.SendLocalizedMessage( 1044281 );// That item is in full repair
				}
				else if ( repairing3.MaxHitPoints <= 2 )
				{
					from.SendLocalizedMessage( 1044278 );// That item has been repaired many times, and will break if repairs are attempted again.
				}
				else
				{
					Container backpack = from.Backpack;
					RepairPotion repairpotion = (RepairPotion)backpack.FindItemByType(typeof(RepairPotion));
					if ( repairpotion != null )
					{
						from.SendLocalizedMessage( 1044279 ); // You repair the item.
						repairing3.MaxHitPoints -= 2;
						repairing3.HitPoints = repairing3.MaxHitPoints;
						repairpotion.Consume();
						from.AddToBackpack( new Bottle() );
					}
				}
			}
			else if ( targeted is BaseWeapon )
			{
				BaseWeapon repairing2 = (BaseWeapon)targeted;
				if ( !repairing2.IsChildOf( from.Backpack ) )
				{
					from.SendLocalizedMessage( 1044275 ); // The item must be in your backpack to repair it.
				}
				else if ( repairing2.HitPoints == repairing2.MaxHitPoints )
				{
					from.SendLocalizedMessage( 1044281 );// That item is in full repair
				}
				else if ( repairing2.MaxHitPoints <= 2 )
				{
					from.SendLocalizedMessage( 1044278 );// That item has been repaired many times, and will break if repairs are attempted again.
				}
				else
				{
					Container backpack = from.Backpack;
					RepairPotion repairpotion = (RepairPotion)backpack.FindItemByType(typeof(RepairPotion));
					if ( repairpotion != null )
					{
						from.SendLocalizedMessage( 1044279 ); // You repair the item.
						repairing2.MaxHitPoints -= 2;
						repairing2.HitPoints = repairing2.MaxHitPoints;
						repairpotion.Consume();
						from.AddToBackpack( new Bottle() );
					}
				}
			}
			else
			{
				from.SendLocalizedMessage( 500426 ); // You can't repair that.
			}
		}
	}
	
}
